/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.trace;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.EventPublisherFactory;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.SmartSubscriber;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.trace.event.TraceEvent;
import com.alibaba.nacos.common.trace.publisher.TraceEventPublisherFactory;
import com.alibaba.nacos.plugin.trace.NacosTracePluginManager;
import com.alibaba.nacos.plugin.trace.spi.NacosTraceSubscriber;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class NacosCombinedTraceSubscriber
extends SmartSubscriber {
    private final Map<Class<? extends TraceEvent>, Set<NacosTraceSubscriber>> interestedEvents = new ConcurrentHashMap<Class<? extends TraceEvent>, Set<NacosTraceSubscriber>>();

    public NacosCombinedTraceSubscriber(Class<? extends TraceEvent> combinedEvent) {
        TraceEventPublisherFactory.getInstance().addPublisherEvent(combinedEvent);
        for (NacosTraceSubscriber each : NacosTracePluginManager.getInstance().getAllTraceSubscribers()) {
            this.filterInterestedEvents(each, combinedEvent);
        }
        NotifyCenter.registerSubscriber((Subscriber)this, (EventPublisherFactory)TraceEventPublisherFactory.getInstance());
    }

    private void filterInterestedEvents(NacosTraceSubscriber plugin, Class<? extends TraceEvent> combinedEvent) {
        for (Class each : plugin.subscribeTypes()) {
            if (!combinedEvent.isAssignableFrom(each)) continue;
            this.interestedEvents.compute(each, (eventClass, nacosTraceSubscribers) -> {
                if (null == nacosTraceSubscribers) {
                    nacosTraceSubscribers = new HashSet<NacosTraceSubscriber>();
                }
                nacosTraceSubscribers.add(plugin);
                return nacosTraceSubscribers;
            });
        }
    }

    public List<Class<? extends Event>> subscribeTypes() {
        return new LinkedList<Class<? extends Event>>(this.interestedEvents.keySet());
    }

    public void onEvent(Event event) {
        Set<NacosTraceSubscriber> subscribers = this.interestedEvents.get(event.getClass());
        if (null == subscribers) {
            return;
        }
        TraceEvent traceEvent = (TraceEvent)event;
        for (NacosTraceSubscriber each : subscribers) {
            if (null != each.executor()) {
                each.executor().execute(() -> this.onEvent0(each, traceEvent));
                continue;
            }
            this.onEvent0(each, traceEvent);
        }
    }

    private void onEvent0(NacosTraceSubscriber subscriber, TraceEvent event) {
        try {
            subscriber.onEvent(event);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void shutdown() {
        NotifyCenter.deregisterSubscriber((Subscriber)this);
    }
}

