/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.cleaner;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.cleaner.AbstractNamingCleaner;
import com.alibaba.nacos.naming.core.v2.event.metadata.MetadataEvent;
import com.alibaba.nacos.naming.core.v2.index.ClientServiceIndexesManager;
import com.alibaba.nacos.naming.core.v2.index.ServiceStorage;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.misc.GlobalConfig;
import com.alibaba.nacos.naming.misc.GlobalExecutor;
import com.alibaba.nacos.naming.misc.Loggers;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.springframework.stereotype.Component;

@Component
public class EmptyServiceAutoCleanerV2
extends AbstractNamingCleaner {
    private static final String EMPTY_SERVICE = "emptyService";
    private final ClientServiceIndexesManager clientServiceIndexesManager;
    private final ServiceStorage serviceStorage;

    public EmptyServiceAutoCleanerV2(ClientServiceIndexesManager clientServiceIndexesManager, ServiceStorage serviceStorage) {
        this.clientServiceIndexesManager = clientServiceIndexesManager;
        this.serviceStorage = serviceStorage;
        GlobalExecutor.scheduleExpiredClientCleaner((Runnable)((Object)this), TimeUnit.SECONDS.toMillis(30L), GlobalConfig.getEmptyServiceCleanInterval(), TimeUnit.MILLISECONDS);
    }

    @Override
    public String getType() {
        return EMPTY_SERVICE;
    }

    @Override
    public void doClean() {
        ServiceManager serviceManager = ServiceManager.getInstance();
        int parallelSize = 100;
        for (String each : serviceManager.getAllNamespaces()) {
            Set<Service> services = serviceManager.getSingletons(each);
            Stream stream = services.size() > parallelSize ? services.parallelStream() : services.stream();
            stream.forEach(this::cleanEmptyService);
        }
    }

    private void cleanEmptyService(Service service) {
        Collection<String> registeredService = this.clientServiceIndexesManager.getAllClientsRegisteredService(service);
        if (registeredService.isEmpty() && this.isTimeExpired(service)) {
            Loggers.SRV_LOG.warn("namespace : {}, [{}] services are automatically cleaned", (Object)service.getNamespace(), (Object)service.getGroupedServiceName());
            this.clientServiceIndexesManager.removePublisherIndexesByEmptyService(service);
            ServiceManager.getInstance().removeSingleton(service);
            this.serviceStorage.removeData(service);
            NotifyCenter.publishEvent((Event)new MetadataEvent.ServiceMetadataEvent(service, true));
        }
    }

    private boolean isTimeExpired(Service service) {
        long currentTimeMillis = System.currentTimeMillis();
        return currentTimeMillis - service.getLastUpdatedTime() >= GlobalConfig.getEmptyServiceExpiredTime();
    }
}

