/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.push;

import com.alibaba.nacos.common.utils.StringUtils;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.VersionUtil;

public class ClientInfo {
    public Version version;
    public ClientType type;

    public ClientInfo(String userAgent) {
        String versionStr = StringUtils.isEmpty((String)userAgent) ? "" : userAgent;
        this.type = ClientType.getType(versionStr);
        if (versionStr.startsWith("vip-client4cpp")) {
            this.type = ClientType.C;
        }
        this.version = this.parseVersion(versionStr);
    }

    private Version parseVersion(String versionStr) {
        if (StringUtils.isBlank((CharSequence)versionStr) || ClientType.UNKNOWN.equals((Object)this.type)) {
            return Version.unknownVersion();
        }
        int versionStartIndex = versionStr.indexOf(":v");
        if (versionStartIndex < 0) {
            return Version.unknownVersion();
        }
        return VersionUtil.parseVersion((String)versionStr.substring(versionStartIndex + 2), null, null);
    }

    public static enum ClientType {
        GO("Nacos-Go-Client"),
        JAVA("Nacos-Java-Client"),
        C("Nacos-C-Client"),
        CSHARP("Nacos-CSharp-Client"),
        PHP("Nacos-Php-Client"),
        DNS("Nacos-DNS"),
        TENGINE("unit-nginx"),
        JAVA_SDK("Nacos-SDK-Java"),
        NACOS_SERVER("Nacos-Server"),
        UNKNOWN("unknown");

        private final String clientTypeDescription;

        private ClientType(String clientTypeDescription) {
            this.clientTypeDescription = clientTypeDescription;
        }

        public String getClientTypeDescription() {
            return this.clientTypeDescription;
        }

        public static ClientType getType(String userAgent) {
            for (ClientType each : ClientType.values()) {
                if (!userAgent.startsWith(each.getClientTypeDescription())) continue;
                return each;
            }
            return UNKNOWN;
        }
    }

    public static class ClientTypeDescription {
        public static final String JAVA_CLIENT = "Nacos-Java-Client";
        public static final String DNSF_CLIENT = "Nacos-DNS";
        public static final String C_CLIENT = "Nacos-C-Client";
        public static final String SDK_CLIENT = "Nacos-SDK-Java";
        public static final String NGINX_CLIENT = "unit-nginx";
        public static final String CPP_CLIENT = "vip-client4cpp";
        public static final String GO_CLIENT = "Nacos-Go-Client";
        public static final String PHP_CLIENT = "Nacos-Php-Client";
        public static final String CSHARP_CLIENT = "Nacos-CSharp-Client";
    }
}

