/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.utils;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.pojo.Subscriber;
import com.alibaba.nacos.naming.selector.SelectorManager;
import com.alibaba.nacos.naming.utils.InstanceUtil;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class ServiceUtil {
    public static List<String> pageServiceName(int pageNo, int pageSize, Collection<String> serviceNameSet) {
        ArrayList<String> result = new ArrayList<String>(serviceNameSet);
        int start = (pageNo - 1) * pageSize;
        if (start < 0) {
            start = 0;
        }
        if (start >= result.size()) {
            return Collections.emptyList();
        }
        int end = start + pageSize;
        if (end > result.size()) {
            end = result.size();
        }
        for (int i = start; i < end; ++i) {
            String serviceName = (String)result.get(i);
            int indexOfSplitter = serviceName.indexOf("@@");
            if (indexOfSplitter > 0) {
                serviceName = serviceName.substring(indexOfSplitter + 2);
            }
            result.set(i, serviceName);
        }
        return result.subList(start, end);
    }

    public static ServiceInfo selectHealthyInstances(ServiceInfo serviceInfo) {
        return ServiceUtil.selectInstances(serviceInfo, true, false);
    }

    public static ServiceInfo selectEnabledInstances(ServiceInfo serviceInfo) {
        return ServiceUtil.selectInstances(serviceInfo, false, true);
    }

    public static ServiceInfo selectInstances(ServiceInfo serviceInfo, String cluster) {
        return ServiceUtil.selectInstances(serviceInfo, cluster, false, false);
    }

    public static ServiceInfo selectInstances(ServiceInfo serviceInfo, boolean healthyOnly, boolean enableOnly) {
        return ServiceUtil.selectInstances(serviceInfo, "", healthyOnly, enableOnly);
    }

    public static ServiceInfo selectInstances(ServiceInfo serviceInfo, String cluster, boolean healthyOnly) {
        return ServiceUtil.selectInstances(serviceInfo, cluster, healthyOnly, false);
    }

    public static ServiceInfo selectInstances(ServiceInfo serviceInfo, String cluster, boolean healthyOnly, boolean enableOnly) {
        return ServiceUtil.doSelectInstances(serviceInfo, cluster, healthyOnly, enableOnly, null);
    }

    public static ServiceInfo selectInstancesWithHealthyProtection(ServiceInfo serviceInfo, ServiceMetadata serviceMetadata, Subscriber subscriber) {
        return ServiceUtil.selectInstancesWithHealthyProtection(serviceInfo, serviceMetadata, subscriber.getCluster(), false, false, subscriber.getIp());
    }

    public static ServiceInfo selectInstancesWithHealthyProtection(ServiceInfo serviceInfo, ServiceMetadata serviceMetadata, boolean healthyOnly, boolean enableOnly, Subscriber subscriber) {
        return ServiceUtil.selectInstancesWithHealthyProtection(serviceInfo, serviceMetadata, subscriber.getCluster(), healthyOnly, enableOnly, subscriber.getIp());
    }

    public static ServiceInfo selectInstancesWithHealthyProtection(ServiceInfo serviceInfo, ServiceMetadata serviceMetadata, String cluster, boolean healthyOnly, boolean enableOnly, String subscriberIp) {
        InstancesFilter filter = (filteredResult, allInstances, healthyCount) -> {
            float threshold;
            if (serviceMetadata == null) {
                return;
            }
            allInstances = filteredResult.getHosts();
            int originalTotal = allInstances.size();
            SelectorManager selectorManager = (SelectorManager)ApplicationUtils.getBean(SelectorManager.class);
            allInstances = selectorManager.select(serviceMetadata.getSelector(), subscriberIp, allInstances);
            filteredResult.setHosts(allInstances);
            long newHealthyCount = healthyCount;
            if (originalTotal != allInstances.size()) {
                newHealthyCount = 0L;
                for (Instance allInstance : allInstances) {
                    if (!allInstance.isHealthy()) continue;
                    ++newHealthyCount;
                }
            }
            if ((threshold = serviceMetadata.getProtectThreshold()) < 0.0f) {
                threshold = 0.0f;
            }
            if ((float)newHealthyCount / (float)allInstances.size() <= threshold) {
                Loggers.SRV_LOG.warn("protect threshold reached, return all ips, service: {}", (Object)filteredResult.getName());
                filteredResult.setReachProtectionThreshold(true);
                List filteredInstances = allInstances.stream().map(i -> {
                    if (!i.isHealthy()) {
                        i = InstanceUtil.deepCopy(i);
                        i.setHealthy(true);
                    }
                    return i;
                }).collect(Collectors.toCollection(LinkedList::new));
                filteredResult.setHosts(filteredInstances);
            }
        };
        return ServiceUtil.doSelectInstances(serviceInfo, cluster, healthyOnly, enableOnly, filter);
    }

    private static ServiceInfo doSelectInstances(ServiceInfo serviceInfo, String cluster, boolean healthyOnly, boolean enableOnly, InstancesFilter filter) {
        ServiceInfo result = new ServiceInfo();
        result.setName(serviceInfo.getName());
        result.setGroupName(serviceInfo.getGroupName());
        result.setCacheMillis(serviceInfo.getCacheMillis());
        result.setLastRefTime(System.currentTimeMillis());
        result.setClusters(cluster);
        result.setReachProtectionThreshold(false);
        HashSet<String> clusterSets = StringUtils.isNotBlank((String)cluster) ? new HashSet<String>(Arrays.asList(cluster.split(","))) : new HashSet();
        long healthyCount = 0L;
        LinkedList<Instance> filteredInstances = new LinkedList<Instance>();
        LinkedList<Instance> allInstances = new LinkedList<Instance>();
        for (Instance ip : serviceInfo.getHosts()) {
            if (!ServiceUtil.checkCluster(clusterSets, ip) || !ServiceUtil.checkEnabled(enableOnly, ip)) continue;
            if (!healthyOnly || ip.isHealthy()) {
                filteredInstances.add(ip);
            }
            if (ip.isHealthy()) {
                ++healthyCount;
            }
            allInstances.add(ip);
        }
        result.setHosts(filteredInstances);
        if (filter != null) {
            filter.doFilter(result, allInstances, healthyCount);
        }
        return result;
    }

    private static boolean checkCluster(Set<String> clusterSets, Instance instance) {
        if (clusterSets.isEmpty()) {
            return true;
        }
        return clusterSets.contains(instance.getClusterName());
    }

    private static boolean checkEnabled(boolean enableOnly, Instance instance) {
        return !enableOnly || instance.isEnabled();
    }

    private static interface InstancesFilter {
        public void doFilter(ServiceInfo var1, List<Instance> var2, long var3);
    }
}

