/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers.v2;

import com.alibaba.nacos.api.annotation.NacosApi;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.remote.Connection;
import com.alibaba.nacos.core.remote.ConnectionManager;
import com.alibaba.nacos.core.remote.ConnectionMeta;
import com.alibaba.nacos.naming.core.v2.client.Client;
import com.alibaba.nacos.naming.core.v2.client.impl.ConnectionBasedClient;
import com.alibaba.nacos.naming.core.v2.client.impl.IpPortBasedClient;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManager;
import com.alibaba.nacos.naming.core.v2.index.ClientServiceIndexesManager;
import com.alibaba.nacos.naming.core.v2.pojo.BatchInstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.InstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.paramcheck.NamingDefaultHttpParamExtractor;
import com.alibaba.nacos.naming.pojo.Subscriber;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@NacosApi
@RestController
@RequestMapping(value={"/v2/ns/client"})
@ExtractorManager.Extractor(httpExtractor=NamingDefaultHttpParamExtractor.class)
public class ClientInfoControllerV2 {
    private final ClientManager clientManager;
    private final ConnectionManager connectionManager;
    private final ClientServiceIndexesManager clientServiceIndexesManager;

    public ClientInfoControllerV2(ClientManager clientManager, ConnectionManager connectionManager, ClientServiceIndexesManager clientServiceIndexesManager) {
        this.clientManager = clientManager;
        this.connectionManager = connectionManager;
        this.clientServiceIndexesManager = clientServiceIndexesManager;
    }

    @GetMapping(value={"/list"})
    @Secured(action=ActionTypes.READ, resource="nacos/admin")
    public Result<List<String>> getClientList() {
        return Result.success(new ArrayList<String>(this.clientManager.allClientId()));
    }

    @GetMapping
    @Secured(action=ActionTypes.READ, resource="nacos/admin")
    public Result<ObjectNode> getClientDetail(@RequestParam(value="clientId") String clientId) throws NacosApiException {
        this.checkClientId(clientId);
        Client client = this.clientManager.getClient(clientId);
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        result.put("clientId", client.getClientId());
        result.put("ephemeral", client.isEphemeral());
        result.put("lastUpdatedTime", client.getLastUpdatedTime());
        if (client instanceof ConnectionBasedClient) {
            result.put("clientType", "connection");
            Connection connection = this.connectionManager.getConnection(clientId);
            ConnectionMeta connectionMetaInfo = connection.getMetaInfo();
            result.put("connectType", connectionMetaInfo.getConnectType());
            result.put("appName", connectionMetaInfo.getAppName());
            result.put("version", connectionMetaInfo.getVersion());
            result.put("clientIp", connectionMetaInfo.getClientIp());
            result.put("clientPort", clientId.substring(clientId.lastIndexOf(95) + 1));
        } else if (client instanceof IpPortBasedClient) {
            result.put("clientType", "ipPort");
            IpPortBasedClient ipPortBasedClient = (IpPortBasedClient)client;
            String responsibleId = ipPortBasedClient.getResponsibleId();
            int idx = responsibleId.lastIndexOf(58);
            result.put("clientIp", responsibleId.substring(0, idx));
            result.put("clientPort", responsibleId.substring(idx + 1));
        }
        return Result.success((Object)result);
    }

    @GetMapping(value={"/publish/list"})
    @Secured(action=ActionTypes.READ, resource="nacos/admin")
    public Result<List<ObjectNode>> getPublishedServiceList(@RequestParam(value="clientId") String clientId) throws NacosApiException {
        this.checkClientId(clientId);
        Client client = this.clientManager.getClient(clientId);
        Collection<Service> allPublishedService = client.getAllPublishedService();
        ArrayList<ObjectNode> res = new ArrayList<ObjectNode>();
        for (Service service : allPublishedService) {
            InstancePublishInfo instancePublishInfo = client.getInstancePublishInfo(service);
            if (instancePublishInfo instanceof BatchInstancePublishInfo) {
                List<InstancePublishInfo> instancePublishInfos = ((BatchInstancePublishInfo)instancePublishInfo).getInstancePublishInfos();
                for (InstancePublishInfo publishInfo : instancePublishInfos) {
                    res.add(this.wrapSingleInstanceNode(publishInfo, service));
                }
                continue;
            }
            res.add(this.wrapSingleInstanceNode(instancePublishInfo, service));
        }
        return Result.success(res);
    }

    private ObjectNode wrapSingleInstanceNode(InstancePublishInfo instancePublishInfo, Service service) {
        ObjectNode item = JacksonUtils.createEmptyJsonNode();
        item.put("namespace", service.getNamespace());
        item.put("group", service.getGroup());
        item.put("serviceName", service.getName());
        item.set("registeredInstance", (JsonNode)this.wrapSingleInstance(instancePublishInfo));
        return item;
    }

    private ObjectNode wrapSingleInstance(InstancePublishInfo instancePublishInfo) {
        ObjectNode instanceInfo = JacksonUtils.createEmptyJsonNode();
        instanceInfo.put("ip", instancePublishInfo.getIp());
        instanceInfo.put("port", instancePublishInfo.getPort());
        instanceInfo.put("cluster", instancePublishInfo.getCluster());
        return instanceInfo;
    }

    @GetMapping(value={"/subscribe/list"})
    @Secured(action=ActionTypes.READ, resource="nacos/admin")
    public Result<List<ObjectNode>> getSubscribeServiceList(@RequestParam(value="clientId") String clientId) throws NacosApiException {
        this.checkClientId(clientId);
        Client client = this.clientManager.getClient(clientId);
        Collection<Service> allSubscribeService = client.getAllSubscribeService();
        ArrayList<ObjectNode> res = new ArrayList<ObjectNode>();
        for (Service service : allSubscribeService) {
            ObjectNode item = JacksonUtils.createEmptyJsonNode();
            item.put("namespace", service.getNamespace());
            item.put("group", service.getGroup());
            item.put("serviceName", service.getName());
            Subscriber subscriber = client.getSubscriber(service);
            ObjectNode subscriberInfo = JacksonUtils.createEmptyJsonNode();
            subscriberInfo.put("app", subscriber.getApp());
            subscriberInfo.put("agent", subscriber.getAgent());
            subscriberInfo.put("addr", subscriber.getAddrStr());
            item.set("subscriberInfo", (JsonNode)subscriberInfo);
            res.add(item);
        }
        return Result.success(res);
    }

    @GetMapping(value={"/service/publisher/list"})
    @Secured(action=ActionTypes.READ, resource="nacos/admin")
    public Result<List<ObjectNode>> getPublishedClientList(@RequestParam(value="namespaceId", required=false, defaultValue="public") String namespaceId, @RequestParam(value="groupName", required=false, defaultValue="DEFAULT_GROUP") String groupName, @RequestParam(value="ephemeral", required=false, defaultValue="true") Boolean ephemeral, @RequestParam(value="serviceName") String serviceName, @RequestParam(value="ip", required=false) String ip, @RequestParam(value="port", required=false) Integer port) {
        Service service = Service.newService(namespaceId, groupName, serviceName, ephemeral);
        Collection<String> allClientsRegisteredService = this.clientServiceIndexesManager.getAllClientsRegisteredService(service);
        ArrayList<ObjectNode> res = new ArrayList<ObjectNode>();
        for (String clientId : allClientsRegisteredService) {
            Client client = this.clientManager.getClient(clientId);
            InstancePublishInfo instancePublishInfo = client.getInstancePublishInfo(service);
            if (instancePublishInfo instanceof BatchInstancePublishInfo) {
                List<InstancePublishInfo> list = ((BatchInstancePublishInfo)instancePublishInfo).getInstancePublishInfos();
                for (InstancePublishInfo info : list) {
                    if (!Objects.equals(info.getIp(), ip) || !Objects.equals(port, info.getPort())) continue;
                    res.add(this.wrapSingleInstance(info).put("clientId", clientId));
                }
                continue;
            }
            if (!Objects.equals(instancePublishInfo.getIp(), ip) || !Objects.equals(port, instancePublishInfo.getPort())) continue;
            res.add(this.wrapSingleInstance(instancePublishInfo).put("clientId", clientId));
        }
        return Result.success(res);
    }

    @GetMapping(value={"/service/subscriber/list"})
    @Secured(action=ActionTypes.READ, resource="nacos/admin")
    public Result<List<ObjectNode>> getSubscribeClientList(@RequestParam(value="namespaceId", required=false, defaultValue="public") String namespaceId, @RequestParam(value="groupName", required=false, defaultValue="DEFAULT_GROUP") String groupName, @RequestParam(value="ephemeral", required=false, defaultValue="true") Boolean ephemeral, @RequestParam(value="serviceName") String serviceName, @RequestParam(value="ip", required=false) String ip, @RequestParam(value="port", required=false) Integer port) {
        Service service = Service.newService(namespaceId, groupName, serviceName, ephemeral);
        Collection<String> allClientsSubscribeService = this.clientServiceIndexesManager.getAllClientsSubscribeService(service);
        ArrayList<ObjectNode> res = new ArrayList<ObjectNode>();
        for (String clientId : allClientsSubscribeService) {
            Client client = this.clientManager.getClient(clientId);
            Subscriber subscriber = client.getSubscriber(service);
            if (!Objects.equals(subscriber.getIp(), ip) || !Objects.equals(port, subscriber.getPort())) continue;
            ObjectNode item = JacksonUtils.createEmptyJsonNode();
            item.put("clientId", clientId);
            item.put("ip", subscriber.getIp());
            item.put("port", subscriber.getPort());
            res.add(item);
        }
        return Result.success(res);
    }

    private void checkClientId(String clientId) throws NacosApiException {
        if (!this.clientManager.contains(clientId)) {
            throw new NacosApiException(HttpStatus.NOT_FOUND.value(), ErrorCode.RESOURCE_NOT_FOUND, "clientId [ " + clientId + " ] not exist");
        }
    }
}

