/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.persistence.datasource;

import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.common.utils.InternetAddressUtil;
import com.alibaba.nacos.persistence.configuration.DatasourceConfiguration;
import com.alibaba.nacos.persistence.datasource.DataSourceService;
import com.alibaba.nacos.persistence.datasource.ExternalDataSourceProperties;
import com.alibaba.nacos.persistence.monitor.DatasourceMetrics;
import com.alibaba.nacos.persistence.utils.ConnectionCheckUtil;
import com.alibaba.nacos.persistence.utils.DatasourcePlatformUtil;
import com.alibaba.nacos.persistence.utils.PersistenceExecutor;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class ExternalDataSourceServiceImpl
implements DataSourceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalDataSourceServiceImpl.class);
    private int queryTimeout = 3;
    private static final int TRANSACTION_QUERY_TIMEOUT = 5;
    private static final int DB_MASTER_SELECT_THRESHOLD = 1;
    private static final String DB_LOAD_ERROR_MSG = "[db-load-error]load jdbc.properties error";
    private List<HikariDataSource> dataSourceList = new ArrayList<HikariDataSource>();
    private JdbcTemplate jt;
    private DataSourceTransactionManager tm;
    private TransactionTemplate tjt;
    private JdbcTemplate testMasterJT;
    private JdbcTemplate testMasterWritableJT;
    private volatile List<JdbcTemplate> testJtList;
    private volatile List<Boolean> isHealthList;
    private volatile int masterIndex;
    private String dataSourceType = "";
    private final String defaultDataSourceType = "";

    @Override
    public void init() {
        this.queryTimeout = ConvertUtils.toInt((String)System.getProperty("QUERYTIMEOUT"), (int)3);
        this.jt = new JdbcTemplate();
        this.jt.setMaxRows(50000);
        this.jt.setQueryTimeout(this.queryTimeout);
        this.testMasterJT = new JdbcTemplate();
        this.testMasterJT.setQueryTimeout(this.queryTimeout);
        this.testMasterWritableJT = new JdbcTemplate();
        this.testMasterWritableJT.setQueryTimeout(1);
        this.testJtList = new ArrayList<JdbcTemplate>();
        this.isHealthList = new ArrayList<Boolean>();
        this.tm = new DataSourceTransactionManager();
        this.tjt = new TransactionTemplate((PlatformTransactionManager)this.tm);
        this.tjt.setTimeout(5);
        this.dataSourceType = DatasourcePlatformUtil.getDatasourcePlatform("");
        if (DatasourceConfiguration.isUseExternalDB()) {
            try {
                this.reload();
            }
            catch (IOException e) {
                LOGGER.error("[ExternalDataSourceService] datasource reload error", (Throwable)e);
                throw new RuntimeException(DB_LOAD_ERROR_MSG, e);
            }
            if (this.dataSourceList.size() > 1) {
                PersistenceExecutor.scheduleTask(new SelectMasterTask(), 10L, 10L, TimeUnit.SECONDS);
            }
            PersistenceExecutor.scheduleTask(new CheckDbHealthTask(), 10L, 10L, TimeUnit.SECONDS);
        }
    }

    @Override
    public synchronized void reload() throws IOException {
        try {
            ArrayList<JdbcTemplate> testJtListNew = new ArrayList<JdbcTemplate>();
            ArrayList<Boolean> isHealthListNew = new ArrayList<Boolean>();
            List<HikariDataSource> dataSourceListNew = new ExternalDataSourceProperties().build((Environment)EnvUtil.getEnvironment(), dataSource -> {
                ConnectionCheckUtil.checkDataSourceConnection(dataSource);
                JdbcTemplate jdbcTemplate = new JdbcTemplate();
                jdbcTemplate.setQueryTimeout(this.queryTimeout);
                jdbcTemplate.setDataSource((DataSource)dataSource);
                testJtListNew.add(jdbcTemplate);
                isHealthListNew.add(Boolean.TRUE);
            });
            List<HikariDataSource> dataSourceListOld = this.dataSourceList;
            List<JdbcTemplate> testJtListOld = this.testJtList;
            this.dataSourceList = dataSourceListNew;
            this.testJtList = testJtListNew;
            this.isHealthList = isHealthListNew;
            new SelectMasterTask().run();
            new CheckDbHealthTask().run();
            if (dataSourceListOld != null && !dataSourceListOld.isEmpty()) {
                for (HikariDataSource dataSource2 : dataSourceListOld) {
                    dataSource2.close();
                }
            }
            if (testJtListOld != null && !testJtListOld.isEmpty()) {
                for (JdbcTemplate oldJdbc : testJtListOld) {
                    oldJdbc.setDataSource(null);
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.error(DB_LOAD_ERROR_MSG, (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public boolean checkMasterWritable() {
        this.testMasterWritableJT.setDataSource(this.jt.getDataSource());
        this.testMasterWritableJT.setQueryTimeout(1);
        String sql = " SELECT @@read_only ";
        try {
            Integer result = (Integer)this.testMasterWritableJT.queryForObject(sql, Integer.class);
            if (result == null) {
                return false;
            }
            return result == 0;
        }
        catch (CannotGetJdbcConnectionException e) {
            LOGGER.error("[db-error] " + e.toString(), (Throwable)e);
            return false;
        }
    }

    @Override
    public JdbcTemplate getJdbcTemplate() {
        return this.jt;
    }

    @Override
    public TransactionTemplate getTransactionTemplate() {
        return this.tjt;
    }

    @Override
    public String getCurrentDbUrl() {
        DataSource ds = this.jt.getDataSource();
        if (ds == null) {
            return "";
        }
        HikariDataSource bds = (HikariDataSource)ds;
        return bds.getJdbcUrl();
    }

    @Override
    public String getHealth() {
        for (int i = 0; i < this.isHealthList.size(); ++i) {
            if (this.isHealthList.get(i).booleanValue()) continue;
            if (i == this.masterIndex) {
                return "DOWN:" + InternetAddressUtil.getIPFromString((String)this.dataSourceList.get(i).getJdbcUrl());
            }
            return "WARN:" + InternetAddressUtil.getIPFromString((String)this.dataSourceList.get(i).getJdbcUrl());
        }
        return "UP";
    }

    @Override
    public String getDataSourceType() {
        return this.dataSourceType;
    }

    class SelectMasterTask
    implements Runnable {
        SelectMasterTask() {
        }

        @Override
        public void run() {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("check master db.");
            }
            boolean isFound = false;
            int index = -1;
            for (HikariDataSource ds : ExternalDataSourceServiceImpl.this.dataSourceList) {
                ++index;
                ExternalDataSourceServiceImpl.this.testMasterJT.setDataSource((DataSource)ds);
                ExternalDataSourceServiceImpl.this.testMasterJT.setQueryTimeout(ExternalDataSourceServiceImpl.this.queryTimeout);
                try {
                    ExternalDataSourceServiceImpl.this.testMasterJT.update("DELETE FROM config_info WHERE data_id='com.alibaba.nacos.testMasterDB'");
                    if (ExternalDataSourceServiceImpl.this.jt.getDataSource() != ds) {
                        LOGGER.warn("[master-db] {}", (Object)ds.getJdbcUrl());
                    }
                    ExternalDataSourceServiceImpl.this.jt.setDataSource((DataSource)ds);
                    ExternalDataSourceServiceImpl.this.tm.setDataSource((DataSource)ds);
                    isFound = true;
                    ExternalDataSourceServiceImpl.this.masterIndex = index;
                    break;
                }
                catch (DataAccessException e) {
                    LOGGER.warn("[master-db] master db access error", (Throwable)e);
                }
            }
            if (!isFound) {
                LOGGER.error("[master-db] master db not found.");
                DatasourceMetrics.getDbException().increment();
            }
        }
    }

    class CheckDbHealthTask
    implements Runnable {
        CheckDbHealthTask() {
        }

        @Override
        public void run() {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("check db health.");
            }
            String sql = "SELECT * FROM config_info_beta WHERE id = 1";
            for (int i = 0; i < ExternalDataSourceServiceImpl.this.testJtList.size(); ++i) {
                JdbcTemplate jdbcTemplate = (JdbcTemplate)ExternalDataSourceServiceImpl.this.testJtList.get(i);
                try {
                    try {
                        jdbcTemplate.queryForMap(sql);
                    }
                    catch (EmptyResultDataAccessException emptyResultDataAccessException) {
                        // empty catch block
                    }
                    ExternalDataSourceServiceImpl.this.isHealthList.set(i, Boolean.TRUE);
                    continue;
                }
                catch (DataAccessException e) {
                    if (i == ExternalDataSourceServiceImpl.this.masterIndex) {
                        LOGGER.error("[db-error] master db {} down.", (Object)InternetAddressUtil.getIPFromString((String)((HikariDataSource)ExternalDataSourceServiceImpl.this.dataSourceList.get(i)).getJdbcUrl()));
                    } else {
                        LOGGER.error("[db-error] slave db {} down.", (Object)InternetAddressUtil.getIPFromString((String)((HikariDataSource)ExternalDataSourceServiceImpl.this.dataSourceList.get(i)).getJdbcUrl()));
                    }
                    ExternalDataSourceServiceImpl.this.isHealthList.set(i, Boolean.FALSE);
                    DatasourceMetrics.getDbException().increment();
                }
            }
        }
    }
}

