/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.sys.module;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.sys.module.ModuleState;
import com.alibaba.nacos.sys.module.ModuleStateBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleStateHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleStateHolder.class);
    private static final ModuleStateHolder INSTANCE = new ModuleStateHolder();
    private final Map<String, ModuleState> moduleStates;
    private final List<ModuleStateBuilder> moduleStateBuilders = new ArrayList<ModuleStateBuilder>();

    private ModuleStateHolder() {
        this.moduleStates = new HashMap<String, ModuleState>();
        for (ModuleStateBuilder each : NacosServiceLoader.load(ModuleStateBuilder.class)) {
            if (each.isIgnore()) continue;
            try {
                this.moduleStateBuilders.add(each);
                ModuleState moduleState = each.build();
                this.moduleStates.put(moduleState.getModuleName(), moduleState);
            }
            catch (Exception e) {
                LOGGER.warn("Build ModuleState failed in builder:{}", (Object)each.getClass().getCanonicalName(), (Object)e);
            }
        }
    }

    public static ModuleStateHolder getInstance() {
        return INSTANCE;
    }

    private void reBuildModuleState() {
        for (ModuleStateBuilder each : this.moduleStateBuilders) {
            if (each.isCacheable()) continue;
            try {
                ModuleState moduleState = each.build();
                this.moduleStates.put(moduleState.getModuleName(), moduleState);
            }
            catch (Exception e) {
                LOGGER.warn("reBuild ModuleState failed in builder:{}", (Object)each.getClass().getCanonicalName(), (Object)e);
            }
        }
    }

    public Optional<ModuleState> getModuleState(String moduleName) {
        this.reBuildModuleState();
        return Optional.ofNullable(this.moduleStates.get(moduleName));
    }

    public Set<ModuleState> getAllModuleStates() {
        this.reBuildModuleState();
        return new HashSet<ModuleState>(this.moduleStates.values());
    }

    public String getStateValueByName(String moduleName, String stateName) {
        return this.getStateValueByName(moduleName, stateName, "");
    }

    public <T> T getStateValueByName(String moduleName, String stateName, T defaultValue) {
        Optional<ModuleState> moduleState = this.getModuleState(moduleName);
        if (!moduleState.isPresent()) {
            return defaultValue;
        }
        return moduleState.get().getState(stateName, defaultValue);
    }

    public <T> T searchStateValue(String stateName, T defaultValue) {
        Object result = null;
        for (ModuleState each : this.getAllModuleStates()) {
            if (!each.getStates().containsKey(stateName)) continue;
            result = each.getStates().get(stateName);
            break;
        }
        return (T)(null == result ? defaultValue : result);
    }
}

