package com.ttk.agg.openapi.sdk;

import java.util.List;

/**
 * 字符串工具类
 *
 */
public final class StringUtil {
    /**
     * 链路追踪logId
     */
    public final static String TRACE_LOG_ID = "logId";

    public static boolean isNullOrEmpty(String str) {
        if (str == null) {
            return true;
        }
        return str.isEmpty();
    }

    public static String join(List<String> elements, String seperator) {
        if (elements == null || elements.isEmpty()) {
            return null;
        }

        if (seperator == null) {
            seperator = "";
        }
        StringBuilder sb = new StringBuilder();
        int length = elements.size();
        for (int index = 0; index < length; index++) {
            if (index > 0) {
                sb.append(seperator);
            }
            sb.append(elements.get(index));
        }
        return sb.toString();
    }

}
