/*
 * Copyright 2021-2030 qixiangyun.com All right reserved. This software is the confidential and proprietary information
 * of qixiangyun.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with qixiangyun.com.
 */
package com.ttk.agg.openapi.sdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ttk.agg.openapi.sdk.dto.CallResult;
import com.ttk.agg.openapi.sdk.dto.InvoiceInspectionParamBody;
import com.ttk.agg.openapi.sdk.inspect.BaseInvoice;

import java.io.IOException;
import java.util.UUID;

/**
 * rpa任务路由配置测试
 */
public class TestRpaTaskRouteConfig {
    public static Object sdkTestYZM(String apiHost, String appKey, String appSecret) {
        String[] strings = new String[]{"15010365441", "15010365442", "13466747147", "13691222319", "15601082018"};
        AggOpenAPI ttkOpenAPI = new AggOpenAPI(apiHost, appKey, appSecret);
        JSONObject jo = new JSONObject();
        jo.put("receiver", strings);
        JSONObject jsonObject = ttkOpenAPI.rest("/v1/YZM/queryAppHeartbeatBatch", jo.toJSONString());
        System.out.println(jsonObject.toJSONString());
        return jsonObject;

    }

    public static Object sdkTestConfig(String apiHost, String appKey, String appSecret) {
        AggOpenAPI ttkOpenAPI = new AggOpenAPI(apiHost, appKey, appSecret);
        ttkOpenAPI.setProxyHost("82.156.132.58");
        ttkOpenAPI.setProxyPort(44024);
        ttkOpenAPI.setProxyUser("xmadghos");
        ttkOpenAPI.setProxyPassword("rOm7oNYzGw");

        String configName = "fpcyWarnMinimumGuaranteeValue";
        JSONObject param = new JSONObject();
        param.put("configName", configName);
        JSONObject jsonObject = ttkOpenAPI.rest("/v1/config/getConfigValue", param.toJSONString());
        System.out.println(jsonObject.toJSONString());
        return jsonObject;

    }

    public static Object sdkTestRpaTaskRouteConfig(String apiHost, String appKey, String appSecret) {
        AggOpenAPI ttkOpenAPI = new AggOpenAPI(apiHost, appKey, appSecret);

        JSONObject param = new JSONObject();
        JSONObject jsonObject = ttkOpenAPI.rest("/v1/rpatask/routeconfig/list", param.toJSONString());
        System.out.println("-----> list: " + jsonObject.toJSONString());

        param = new JSONObject();
        param.put("taskType", "sb");
        jsonObject = ttkOpenAPI.rest("/v1/rpatask/routeconfig/create", param.toJSONString());
        System.out.println("-----> create: " + jsonObject.toJSONString());

        param = new JSONObject();
        jsonObject = ttkOpenAPI.rest("/v1/rpatask/routeconfig/list", param.toJSONString());
        System.out.println("-----> list: " + jsonObject.toJSONString());

        Object objResult = jsonObject.get("value");
        if (objResult instanceof JSONArray) {
            JSONArray arr = (JSONArray) objResult;
            if (arr.size() > 0) {
                JSONObject item = ((JSONObject) arr.get(0));
                item.put("taskType", "qc");
                item.put("status", false);
                item.put("areaCode", "5100");
                jsonObject = ttkOpenAPI.rest("/v1/rpatask/routeconfig/update", item.toJSONString());
                System.out.println("-----> update: " + jsonObject.toJSONString());

                /*JSONObject lastItem = ((JSONObject) arr.get(arr.size() - 1));
                jsonObject = ttkOpenAPI.rest("/v1/rpatask/routeconfig/del", lastItem.toJSONString());
                System.out.println("-----> del: " + jsonObject.toJSONString());*/
            }
        }

        return jsonObject;

    }

    public static void  sdkTestOrgCreateInfo(String apiHost, String appKey, String appSecret){
        String bb = "{\"aggOrgName\":\"AggOrgName6\",\"nsrsbh\":\"12345678901234566\",\"orgTaxLogin\":{\"dq\":\"31\",\"gdsdlfs\":\"2\",\"gdsdlzh\":\"Gdsdlzh\",\"gdsdlmm\":\"Gdsdlmm\",\"grdlfs\":null,\"sflx\":null,\"zrrsfzh\":null,\"gryhm\":null,\"gryhmm\":null,\"sjhm\":null}}";
        //bb = "{\"nsrsbh\":\"91441900MA559FN158\",\"aggOrgName\":\"畅捷通-东莞智力本科技有限公司测试1.5版本链路\",\"isCollectTaxInfo\":true,\"orgTaxLogin\":{\"dq\":\"44\",\"gdsdlfs\":\"2\",\"gdsdlzh\":\"17779724039\",\"gdsdlmm\":\"STar07090521\"}}";
        bb = "{\"nsrsbh\":\"91441900MA559FN158\",\"aggOrgName\":\"畅捷通-东莞智力本科技有限公司测试1.5版本链路\",\"isCollectTaxInfo\":true,\"orgTaxLogin\":{\"gdsdlfs\":\"2\",\"gdsdlmm\":\"STar07090521\",\"gdsdlzh\":\"17779724039\",\"dq\":\"44\"}}";

        try {
            AggOpenAPI ttkOpenAPI = new AggOpenAPI(apiHost, appKey, appSecret);
            JSONObject result = ttkOpenAPI.rest("/v1/AGG/org/createInfo", bb);//
            System.out.println("企业信息状态:" + result.toJSONString());
            //if(apiHost.endsWith("/v2")) {
            //    if (result.getBooleanValue("success")) {
            //        System.out.println("企业信息状态[v2]:" + result.get("data").toString());
            //    } else {
            //        System.out.println("企业信息状态[v2]查询失败！原因：" + result.getJSONObject("error").getString("message"));
            //    }
            //} else {
                if (result.getJSONObject("result").getBooleanValue("success")) {
                    System.out.println("企业信息状态:" + result.get("value").toString());
                } else {
                    System.out.println("企业信息状态查询失败！原因：" + result.getJSONObject("error").getString("message"));
                }
            //}
        }catch (Exception ex){
            System.out.println("ex:" + ex.getMessage());
            System.out.println("ex:" + ex.getStackTrace());
            ex.printStackTrace();
        }
    }

    public static void  sdkTestOrgQyxx(String apiHost, String appKey, String appSecret){
        String bb = "{\"zrrxm\":\"韩夏梅\",\"loginType\":1,\"etaxLoginUrl\":\"https://etax.beijing.chinatax.gov.cn/xxmh/html/index.html\",\"dlmm\":\"ABCD1234abcdd\",\"zrrsfzh\":\"23900********32026\",\"bsrSflx\":\"1\",\"orgId\":365779984688128,\"gsdlmm\":\"\",\"taskType\":\"orginfo-node\",\"gssbmm\":\"\",\"srcId\":365779984688128,\"dlzh\":\"911101145938927286\",\"appKey\":10001040,\"aggOrgId\":359585227513984,\"ss\":\"11\",\"gsdlzh\":\"\",\"nsrmc\":\"北京浩正天晟科技有限责任公司1027\",\"bssjhm\":\"1581022221\",\"sbyf\":\"202212\",\"sflx\":\"CWFZR\",\"userId\":364543246978816,\"url\":\"https://etax.beijing.chinatax.gov.cn/xxmh/html/index.html\",\"nsrsbh\":\"911101145938927286\",\"zrrmm\":\"Aa123456\",\"ebclsh\":\"e1d62a6e-66b9-4baa-a47f-2b1da0f8bbc8\",\"dlfs\":2,\"crawling\":\"loadNsrxx\"}";

        try {
            AggOpenAPI ttkOpenAPI = new AggOpenAPI(apiHost, appKey, appSecret);
            JSONObject result = ttkOpenAPI.rest("/v1/SBRelation/qyxx", bb);//
            System.out.println("企业信息状态:" + JSONObject.toJSONString(result, SerializerFeature.WriteMapNullValue));
            //if(apiHost.endsWith("/v2")){
            //    if (result.getBooleanValue("success")) {
            //        System.out.println("企业信息状态[v2]:" + result.get("data").toString());
            //    } else {
            //        System.out.println("企业信息状态[v2]查询失败！原因：" + result.getString("message"));
            //    }
            //}else {
                if (result.getJSONObject("result").getBooleanValue("success")) {
                    System.out.println("企业信息状态:" + result.get("value").toString());
                } else {
                    System.out.println("企业信息状态查询失败！原因：" + result.getJSONObject("error").getString("message"));
                }
            //}
        }catch (Exception ex){
            System.out.println("ex:" + ex.getMessage());
            System.out.println("ex:" + ex.getStackTrace());
            ex.printStackTrace();
        }
    }

    public static void  sdkTestQueryResult(String apiHost, String appKey, String appSecret){
        String bb = "{\"lsh\":\"442281105659904\",\"sourceVersion\":\"v1.5\",\"orgId\":365780582218752}";

        try {
            AggOpenAPI ttkOpenAPI = new AggOpenAPI(apiHost, appKey, appSecret);
            JSONObject result = ttkOpenAPI.rest("/v1/SBRelation/result", bb);
            System.out.println("queryResult:" + JSONObject.toJSONString(result, SerializerFeature.WriteMapNullValue));
            //if(apiHost.endsWith("/v2")) {
            //    if (result.getBooleanValue("success")) {
            //        System.out.println("queryResult[v2]:" + result.get("data").toString());
            //    } else {
            //        System.out.println("queryResult[v2]查询失败！原因：" + result.getJSONObject("error").getString("message"));
            //    }
            //} else {
                if (result.getJSONObject("result").getBooleanValue("success")) {
                    System.out.println("queryResult:" + result.get("value").toString());
                } else {
                    System.out.println("queryResult查询失败！原因：" + result.getJSONObject("error").getString("message"));
                }
            //}
        }catch (Exception ex){
            System.out.println("ex:" + ex.getMessage());
            System.out.println("ex:" + ex.getStackTrace());
            ex.printStackTrace();
        }
    }

    public static void  sdkTestCreatInfo(String apiHost, String appKey, String appSecret){
        String bb = "{\"nsrsbh\":\"91110108MA003L7J0C\",\"aggOrgName\":\"捷付睿通股份有限公司北京分公司0112\",\"dq\":\"11\",\"orgTaxLogin\":{\"dq\":\"11\",\"gdsdlfs\":\"2\",\"gdsdlzh\":\"姜春宇\",\"gdsdlmm\":\"Jf123456\",\"grdlfs\":\"1\",\"sflx\":\"BSY\",\"gryhm\":\"91110108MA003L7J0C\",\"gryhmm\":\"Jf123456\",\"zrrsfzh\":\"230902199511290325\"}}";

        try {
            System.out.println();
            AggOpenAPI ttkOpenAPI = new AggOpenAPI(apiHost, appKey, appSecret);
            JSONObject result = ttkOpenAPI.rest("/v1/AGG/org/createInfo", bb);
            System.out.println("creatInfo:" + JSONObject.toJSONString(result, SerializerFeature.WriteMapNullValue));
            //if(apiHost.endsWith("/v2")) {
            //    if (result.getBooleanValue("success")) {
            //        System.out.println("creatInfo[v2]:" + result.get("data").toString());
            //    } else {
            //        System.out.println("creatInfo[v2]失败！原因：" + result.getString("message"));
            //    }
            //} else {
                if (result.getJSONObject("result").getBooleanValue("success")) {
                    System.out.println("creatInfo:" + result.get("value").toString());
                } else {
                    System.out.println("creatInfo失败！原因：" + result.getJSONObject("error").getString("message"));
                }
            //}
        }catch (Exception ex){
            System.out.println("ex:" + ex.getMessage());
            System.out.println("ex:" + ex.getStackTrace());
            ex.printStackTrace();
        }
    }

    public static void  sdkTestOrgCountV11(String apiHost, String appKey, String appSecret) {
        String bb = "{}";

        try {
            System.out.println();
            AggOpenAPI ttkOpenAPI = new AggOpenAPI(apiHost, appKey, appSecret);
            JSONObject result = ttkOpenAPI.rest("/v1/AGG/orgGount", bb);
            System.out.println("OrgCountV11:" +JSONObject.toJSONString(result, SerializerFeature.WriteMapNullValue));
            if (result.getJSONObject("result").getBooleanValue("success")) {
                System.out.println("OrgCountV11:" + result.get("value").toString());
            } else {
                System.out.println("OrgCountV11失败！原因：" + result.getJSONObject("error").getString("message"));
            }
        } catch (Exception ex) {
            System.out.println("ex:" + ex.getMessage());
            System.out.println("ex:" + ex.getStackTrace());
            ex.printStackTrace();
        }
    }

    public static void  sdkTestOrgCountV22(String apiHost, String appKey, String appSecret) {
        String bb = "{}";

        try {
            System.out.println();
            AggOpenAPI ttkOpenAPI = new AggOpenAPI(apiHost, appKey, appSecret);
            JSONObject result = ttkOpenAPI.rest("/v2/public/org-count", bb);
            System.out.println("OrgCountV22:" + JSONObject.toJSONString(result, SerializerFeature.WriteMapNullValue));
            if (result.getBooleanValue("success")) {
                System.out.println("OrgCountV22:" + result.get("data").toString());
            } else {
                System.out.println("OrgCountV22失败！原因：" + result.getString("message"));
            }
        } catch (Exception ex) {
            System.out.println("ex:" + ex.getMessage());
            System.out.println("ex:" + ex.getStackTrace());
            ex.printStackTrace();
        }
    }

    public static void  sdkTestOrgCountV21(String apiHost, String appKey, String appSecret) {
        String bb = "{}";

        try {
            System.out.println();
            AggOpenAPI ttkOpenAPI = new AggOpenAPI(apiHost, appKey, appSecret);
            JSONObject result = ttkOpenAPI.rest("/v2/public/orgGount", bb);
            System.out.println("OrgCountV21:" + JSONObject.toJSONString(result, SerializerFeature.WriteMapNullValue));
            if (result.getBooleanValue("success")) {
                System.out.println("OrgCountV21:" + result.get("data").toString());
            } else {
                System.out.println("OrgCountV21失败！原因：" + result.getString("message"));
            }
        } catch (Exception ex) {
            System.out.println("ex:" + ex.getMessage());
            System.out.println("ex:" + ex.getStackTrace());
            ex.printStackTrace();
        }
    }

    public static void  sdkTestOrgCountV12(String apiHost, String appKey, String appSecret) {
        String bb = "{}";

        try {
            System.out.println();
            AggOpenAPI ttkOpenAPI = new AggOpenAPI(apiHost, appKey, appSecret);
            JSONObject result = ttkOpenAPI.rest("/v1/AGG/org-count", bb);
            System.out.println("OrgCountV12:" + JSONObject.toJSONString(result, SerializerFeature.WriteMapNullValue));
            if (result.getJSONObject("result").getBooleanValue("success")) {
                System.out.println("OrgCountV12:" + result.get("value").toString());
            } else {
                System.out.println("OrgCountV12失败！原因：" + result.getJSONObject("error").getString("message"));
            }
        } catch (Exception ex) {
            System.out.println("ex:" + ex.getMessage());
            System.out.println("ex:" + ex.getStackTrace());
            ex.printStackTrace();
        }
    }

    public static void  sdkTestQueryAppKeysByModuleV1(String apiHost, String appKey, String appSecret) {
        String bb = "{\"apiModuleCode\":\"FPCY\"}";

        try {
            System.out.println();
            AggOpenAPI ttkOpenAPI = new AggOpenAPI(apiHost, appKey, appSecret);
            JSONObject result = ttkOpenAPI.rest("/v1/AGG/queryAppKeysByApiModuleCode", bb);
            System.out.println("queryAppKeys:" + JSONObject.toJSONString(result, SerializerFeature.WriteMapNullValue));
            //if(apiHost.endsWith("/v2")) {
            //    if (result.getBooleanValue("success")) {
            //        System.out.println("queryAppKeys[v2]:" + result.get("data").toString());
            //    } else {
            //        System.out.println("queryAppKeys[v2]失败！原因：" + result.getString("message"));
            //    }
            //} else {
                if (result.getJSONObject("result").getBooleanValue("success")) {
                    System.out.println("queryAppKeys[v1]:" + result.get("value").toString());
                } else {
                    System.out.println("queryAppKeys[v1]失败！原因：" + result.getJSONObject("error").getString("message"));
                }
            //}
        } catch (Exception ex) {
            System.out.println("ex:" + ex.getMessage());
            System.out.println("ex:" + ex.getStackTrace());
            ex.printStackTrace();
        }
    }

    public static void  sdkTestQueryAppKeysByModuleV2(String apiHost, String appKey, String appSecret) {
        String bb = "{\"apiModuleCode\":\"FPCY\"}";

        try {
            System.out.println();
            AggOpenAPI ttkOpenAPI = new AggOpenAPI(apiHost, appKey, appSecret);
            JSONObject result = ttkOpenAPI.rest("/v2/public/queryAppKeysByApiModuleCode", bb);
            System.out.println("queryAppKeys:" + JSONObject.toJSONString(result, SerializerFeature.WriteMapNullValue));
            if(apiHost.endsWith("/v2")) {
                if (result.getBooleanValue("success")) {
                    System.out.println("queryAppKeys[v2]:" + result.get("data").toString());
                } else {
                    System.out.println("queryAppKeys[v2]失败！原因：" + result.getString("message"));
                }
            }// else {
            //    if (result.getJSONObject("result").getBooleanValue("success")) {
            //        System.out.println("queryAppKeys[v1]:" + result.get("value").toString());
            //    } else {
            //        System.out.println("queryAppKeys[v1]失败！原因：" + result.getJSONObject("error").getString("message"));
            //    }
            //}
        } catch (Exception ex) {
            System.out.println("ex:" + ex.getMessage());
            System.out.println("ex:" + ex.getStackTrace());
            ex.printStackTrace();
        }
    }

    public static void  sdkTestFPRZSBXXV1(String apiHost, String appKey, String appSecret) {
        String bb = "{ \"nsrsbh\": \"91110105MA04BDRR90\"}";

        try {
            System.out.println();
            AggOpenAPI ttkOpenAPI = new AggOpenAPI(apiHost, appKey, appSecret);
            JSONObject result = ttkOpenAPI.rest("/v1/FPRZ/sbxx", bb);
            System.out.println("fprzsbxx:" + JSONObject.toJSONString(result, SerializerFeature.WriteMapNullValue));
            if (result.getJSONObject("result").getBooleanValue("success")) {
                System.out.println("fprzsbxx[v1]:" + result.get("value").toString());
            } else {
                System.out.println("fprzsbxx[v1]失败！原因：" + result.getJSONObject("error").getString("message"));
            }
        } catch (Exception ex) {
            System.out.println("ex:" + ex.getMessage());
            System.out.println("ex:" + ex.getStackTrace());
            ex.printStackTrace();
        }
    }

    public static void  sdkTestFPRZSBXXV2(String apiHost, String appKey, String appSecret) {
        String bb = "{ \"nsrsbh\": \"91110105MA04BDRR90\"}";

        try {
            System.out.println();
            AggOpenAPI ttkOpenAPI = new AggOpenAPI(apiHost, appKey, appSecret);
            JSONObject result = ttkOpenAPI.rest("/v2/invoice/rz/sbxx", bb);
            System.out.println("fprzsbxx:" + JSONObject.toJSONString(result, SerializerFeature.WriteMapNullValue));
            if (result.getBooleanValue("success")) {
                System.out.println("fprzsbxx[v2]:" + result.get("data").toString());
            } else {
                System.out.println("fprzsbxx[v2]失败！原因：" + result.getString("message"));
            }
        } catch (Exception ex) {
            System.out.println("ex:" + ex.getMessage());
            System.out.println("ex:" + ex.getStackTrace());
            ex.printStackTrace();
        }
    }

    public static void  sdkTestFPRZTjqrsqjgV1(String apiHost, String appKey, String appSecret) {
        String bb = "{ \"nsrsbh\": \"91110105MA04BDRR90\",\"id\": 367548510967808}";
        // release 环境
        //bb = "{ \"nsrsbh\": \"91110105MA04BDRR90\",\"id\": 430544824242176}";
        // online 环境
        //bb = "{ \"nsrsbh\": \"91110105MA04BDRR90\",\"id\": 454805227606080}";

        try {
            System.out.println();
            AggOpenAPI ttkOpenAPI = new AggOpenAPI(apiHost, appKey, appSecret);
            JSONObject result = ttkOpenAPI.rest("/v1/FPRZ/tjqrsqjg", bb);
            System.out.println("fprzTjqrsqjg:" + JSONObject.toJSONString(result, SerializerFeature.WriteMapNullValue));
            if (result.getJSONObject("result").getBooleanValue("success")) {
                System.out.println("fprzTjqrsqjg[v1]:" + result.get("value").toString());
            } else {
                System.out.println("fprzTjqrsqjg[v1]失败！原因：" + result.getJSONObject("error").getString("message"));
            }
        } catch (Exception ex) {
            System.out.println("ex:" + ex.getMessage());
            System.out.println("ex:" + ex.getStackTrace());
            ex.printStackTrace();
        }
    }

    public static void  sdkTestFPRZTjqrsqjgV2(String apiHost, String appKey, String appSecret) {
        String bb = "{ \"nsrsbh\": \"91110105MA04BDRR90\",\"id\": 367548510967808}";
        // release 环境
        //bb = "{ \"nsrsbh\": \"91110105MA04BDRR90\",\"id\": 430544824242176}";
        // online 环境
        //bb = "{ \"nsrsbh\": \"91110105MA04BDRR90\",\"id\": 454805227606080}";

        try {
            System.out.println();
            AggOpenAPI ttkOpenAPI = new AggOpenAPI(apiHost, appKey, appSecret);
            JSONObject result = ttkOpenAPI.rest("/v2/invoice/rz/tjqrsqjg", bb);
            System.out.println("fprzTjqrsqjg:" + JSONObject.toJSONString(result, SerializerFeature.WriteMapNullValue));
            if (result.getBooleanValue("success")) {
                System.out.println("fprzTjqrsqjg[v2]:" + result.get("data").toString());
            } else {
                System.out.println("fprzTjqrsqjg[v2]失败！原因：" + result.getString("message"));
            }
        } catch (Exception ex) {
            System.out.println("ex:" + ex.getMessage());
            System.out.println("ex:" + ex.getStackTrace());
            ex.printStackTrace();
        }
    }

    public static void  sdkTestAGGUpload(String apiHost, String appKey, String appSecret) {
        String bb = "{}";
        try {
            System.out.println();
            AggOpenAPI ttkOpenAPI = new AggOpenAPI(apiHost, appKey, appSecret);
            JSONObject result = ttkOpenAPI.rest("/v1/AGG/file/upload", bb);
            System.out.println("agg upload:" + JSONObject.toJSONString(result, SerializerFeature.WriteMapNullValue));
            if (result.getJSONObject("result").getBooleanValue("success")) {
                System.out.println("agg upload[v1]:" + result.get("value"));
            } else {
                System.out.println("agg upload[v1]失败！原因：" + result.getJSONObject("error").getString("message"));
            }
        } catch (Exception ex) {
            System.out.println("ex:" + ex.getMessage());
            System.out.println("ex:" + ex.getStackTrace());
            ex.printStackTrace();
        }
    }

    public static void  sdkTestSBPreprocess(String apiHost, String appKey, String appSecret) {
        String bb = "{}";
        try {
            System.out.println();
            AggOpenAPI ttkOpenAPI = new AggOpenAPI(apiHost, appKey, appSecret);
            JSONObject result = ttkOpenAPI.rest("/v1/SB/preprocess/hello", bb);
            System.out.println("sb preprocess hello:" + JSONObject.toJSONString(result, SerializerFeature.WriteMapNullValue));
            if (result.getJSONObject("result").getBooleanValue("success")) {
                System.out.println("sb preprocess hello[v1]:" + result.get("value").toString());
            } else {
                System.out.println("sb preprocess hello[v1]失败！原因：" + result.getJSONObject("error").getString("message"));
            }
        } catch (Exception ex) {
            System.out.println("ex:" + ex.getMessage());
            System.out.println("ex:" + ex.getStackTrace());
            ex.printStackTrace();
        }
    }

   public static void sbxx(String apiHost, String appKey, String appSecret) {
       AggOpenAPI openAPI = new AggOpenAPI(apiHost, appKey, appSecret);
       JSONObject param = new JSONObject();
       JSONObject result;

       Long beginTime = System.currentTimeMillis();
       System.out.println("申报信息接口开始调用：" + beginTime);
       param.put("nsrsbh", "91320811MA1XUPQKX8");
       result = openAPI.rest("/invoice/rz/sqSkssqCj", param.toJSONString());
       System.out.println(result.toJSONString());
       Long endTime = System.currentTimeMillis();
       System.out.println("申报信息接口调用时间：" + (endTime - beginTime));
   }

    public static void cy(String apiHost, String appKey, String appSecret){
        AggOpenAPI openAPI = new AggOpenAPI(apiHost, appKey, appSecret);
        openAPI.setConnectTimeout(30000);
        openAPI.setSocketTimeout(30000);
        openAPI.setConnectionRequestTimeout(3);
        JSONObject result;
//        String request = "{\"cyList\":[{\"fpdm\":\"045002100211\",\"fphm\":\"44394420\",\"kprq\":\"2023-09-24\",\"jym\":\"043829\"}],\"orderId\":\"12344abcad\"}";
        String request = "{\"cyList\":[{\"fpdm\":\"045002100211\",\"fphm\":\"44394420\",\"kprq\":\"2023-09-24\",\"jym\":\"043829\"}]}";
//        result = openAPI.rest("/FP/cy", request, 30000);
        result = openAPI.rest("/FP/cy", request);
        System.out.println(result.toJSONString());
    }

    public static void customizedCheck(String apiHost, String appKey, String appSecret){
        AggOpenAPI openAPI = new AggOpenAPI(apiHost, appKey, appSecret);
//        openAPI.setConnectTimeout(3);
//        openAPI.setSocketTimeout(3);
        JSONObject result;
        String request = "{\n" +
                "  \"invoiceCode\": \"045002100211\",\n" +
                "  \"invoiceNumber\": \"44394420\",\n" +
                "  \"billingDate\": \"2023-09-24\",\n" +
                "  \"checkCode\": \"043829\",\n" +
                "  \"flowId\": \"asdfasdfasdfadsfasdfdsfsdf\"\n" +
                "}";
//        String request = "{\n" +
//                "  \"invoiceCode\": \"041001800117\",\n" +
//                "  \"invoiceNumber\": \"00789339\",\n" +
//                "  \"billingDate\": \"20190821\",\n" +
////                "  \"checkCode\": \"043829\",\n" +
//                "  \"flowId\": \"asdfasdfasdfadsfasdfdsfsdf\"\n" +
//                "}";
//        String request = "{\n" +
//                "  \"invoiceNumber\": \"24922000000006648630\",\n" +
//                "  \"billingDate\": \"2024-02-06\",\n" +
//                "  \"totalAmount\": \"3270.92\",\n" +
//                "  \"flowId\": \"asdfasdfasdfadsfasdfdsfsdf\"\n" +
//                "}";
        result = openAPI.rest("/v2/invoice/customizedCheck", request);
        System.out.println(result.toJSONString());
    }
    public static void check(String apiHost, String appKey, String appSecret){
        AggOpenAPI openAPI = new AggOpenAPI(apiHost, appKey, appSecret);
//        openAPI.setConnectTimeout(3);
//        openAPI.setSocketTimeout(3);
        InvoiceInspectionParamBody invoiceInspectionParamBody = new InvoiceInspectionParamBody();
        invoiceInspectionParamBody.setInvoiceCode("011002100117");
        invoiceInspectionParamBody.setInvoiceNumber("01715770");
        invoiceInspectionParamBody.setBillingDate("2024-02-29");
        invoiceInspectionParamBody.setTotalAmount("8000.00");
        CallResult<BaseInvoice> result = openAPI.check(invoiceInspectionParamBody);
        System.out.print(JSON.toJSON(result));
    }

    public static void check1(String apiHost, String appKey, String appSecret){
        AggOpenAPI openAPI = new AggOpenAPI(apiHost, appKey, appSecret);
//        openAPI.setConnectTimeout(3);
//        openAPI.setSocketTimeout(3);
        InvoiceInspectionParamBody invoiceInspectionParamBody = new InvoiceInspectionParamBody();
//        invoiceInspectionParamBody.setInvoiceCode("045002100211");
        invoiceInspectionParamBody.setInvoiceNumber("24922000000006648630");
        invoiceInspectionParamBody.setBillingDate("2024-02-06");
        invoiceInspectionParamBody.setTotalAmount("3270.92");
//        invoiceInspectionParamBody.setCheckCode("043829");
        CallResult<BaseInvoice> result = openAPI.check(invoiceInspectionParamBody);
        System.out.print(JSON.toJSON(result));
    }
    public static void main(String[] args) {
//        TestRpaTaskRouteConfig.customizedCheck("https://api.qixiangyun.com", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        TestRpaTaskRouteConfig.cy("https://api.qixiangyun.com", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
//        TestRpaTaskRouteConfig.check("https://api.qixiangyun.com", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        //TestRpaTaskRouteConfig.sdkTestYZM("http://localhost:8081","10001990","teKcBN8s77Vu1BIMwT1j8pExTpOLbJsRTaetE1ndbO9L5t1O");
        //TestRpaTaskRouteConfig.sdkTestConfig("http://localhost:8081", "10001990", "teKcBN8s77Vu1BIMwT1j8pExTpOLbJsRTaetE1ndbO9L5t1O");
        //TestRpaTaskRouteConfig.sdkTestConfig("http://release-agg-api.qixiangyun.com", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
//        TestRpaTaskRouteConfig.sdkTestConfig("https://api.qixiangyun.com", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        //TestRpaTaskRouteConfig.sdkTestProxy("http://api.qixiangyun.com", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5"
        //        , "http://123.57.52.106:9001/get_proxies?area=1100");

        //TestRpaTaskRouteConfig.sdkTestProxy("http://api.qixiangyun.com", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5", "https://www.ip138.com/");
        //TestRpaTaskRouteConfig.sdkTestRpaTaskRouteConfig("http://localhost:8081", "10001990", "teKcBN8s77Vu1BIMwT1j8pExTpOLbJsRTaetE1ndbO9L5t1O");

        //TestRpaTaskRouteConfig.sdkTestOrgCreateInfo("http://localhost:8081", "10001990", "teKcBN8s77Vu1BIMwT1j8pExTpOLbJsRTaetE1ndbO9L5t1O");
        //TestRpaTaskRouteConfig.sdkTestOrgCreateInfo("http://localhost:8081", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");

        //TestRpaTaskRouteConfig.sdkTestOrgCreateInfo("http://test-agg-api.qixiangyun.com", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");

        //TestRpaTaskRouteConfig.sdkTestOrgCreateInfo("http://test-agg-api.qixiangyun.com", "10001991", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        //TestRpaTaskRouteConfig.sdkTestOrgCreateInfo("http://127.0.0.1:8081", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");

        //ThreadContext.put(StringUtil.TRACE_LOG_ID, UUID.randomUUID().toString().replace("-",""));
        //System.out.println(ThreadContext.get(StringUtil.TRACE_LOG_ID));

        //TestRpaTaskRouteConfig.sdkTestOrgQyxx("http://127.0.0.1:8081", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        //TestRpaTaskRouteConfig.sdkTestQueryResult("http://127.0.0.1:8081", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");

        //System.setProperty("http.proxySet", "true");
        //System.setProperty("http.proxyHost", "127.0.0.1");
        //System.setProperty("https.proxyHost", "127.0.0.1");
        //System.setProperty("http.proxyPort", "8888");
        //System.setProperty("https.proxyPort", "8888");
        //TestRpaTaskRouteConfig.sdkTestOrgQyxx("http://test-agg-api.qixiangyun.com", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        //TestRpaTaskRouteConfig.sdkTestOrgQyxx("http://dev-agg-api.qixiangyun.com", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        //TestRpaTaskRouteConfig.sdkTestOrgQyxx("http://release-agg-api.qixiangyun.com", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        //TestRpaTaskRouteConfig.sdkTestOrgQyxx("http://127.0.0.1:8081/v1", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        //TestRpaTaskRouteConfig.sdkTestOrgQyxx("http://127.0.0.1:8081/v1/v2", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        //TestRpaTaskRouteConfig.sdkTestOrgQyxx("http://127.0.0.1:8081/v2", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");

        //TestRpaTaskRouteConfig.sdkTestCreatInfo("http://test-agg-api.qixiangyun.com", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        //TestRpaTaskRouteConfig.sdkTestCreatInfo("http://127.0.0.1:8081/v1", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        //TestRpaTaskRouteConfig.sdkTestCreatInfo("http://127.0.0.1:8081/v2", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");


        //TestRpaTaskRouteConfig.sdkTestOrgCountV11("http://127.0.0.1:8081/v1", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        //TestRpaTaskRouteConfig.sdkTestOrgCountV22("http://127.0.0.1:8081/v2", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        //TestRpaTaskRouteConfig.sdkTestOrgCountV12("http://127.0.0.1:8081/v1", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        //TestRpaTaskRouteConfig.sdkTestOrgCountV21("http://127.0.0.1:8081/v2", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");

        //TestRpaTaskRouteConfig.sdkTestQueryAppKeysByModuleV1("http://127.0.0.1:8081", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        //TestRpaTaskRouteConfig.sdkTestQueryAppKeysByModuleV2("http://127.0.0.1:8081", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");

        //TestRpaTaskRouteConfig.sdkTestFPRZTjqrsqjgV1("http://127.0.0.1:8081", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        //TestRpaTaskRouteConfig.sdkTestFPRZTjqrsqjgV2("http://127.0.0.1:8081", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        //TestRpaTaskRouteConfig.sdkTestFPRZTjqrsqjgV1("http://release-agg-api.qixiangyun.com", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        //TestRpaTaskRouteConfig.sdkTestFPRZTjqrsqjgV2("http://release-agg-api.qixiangyun.com", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        //TestRpaTaskRouteConfig.sdkTestFPRZTjqrsqjgV1("http://api.qixiangyun.com", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        //TestRpaTaskRouteConfig.sdkTestFPRZTjqrsqjgV2("http://api.qixiangyun.com", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");

        //TestRpaTaskRouteConfig.sdkTestFPRZSBXXV1("http://127.0.0.1:8081/v1", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        //TestRpaTaskRouteConfig.sdkTestFPRZSBXXV2("http://127.0.0.1:8081/v2", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        //TestRpaTaskRouteConfig.sdkTestFPRZSBXXV2("http://dev-agg-api.qixiangyun.com/v2", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        //TestRpaTaskRouteConfig.sdkTestFPRZSBXXV2("http://test-agg-api.qixiangyun.com/v2", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");

        //TestRpaTaskRouteConfig.sdkTestAGGUpload("http://127.0.0.1:8081/v1", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");
        //TestRpaTaskRouteConfig.sdkTestSBPreprocess("http://127.0.0.1:8081/v1", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");

        //TestRpaTaskRouteConfig.sbxx("http://127.0.0.1:8081/v2", "10001999", "DkrEhNFor4tI9Pcz1aTp0xsxIX3sd5hV2o2mwbBUSuA0w1N5");

        //String jsonStr = "{\"aa\":\"11\", \"cc\":null}";
        //JSONObject jsonObject =  JSONObject.parseObject(jsonStr, Feature.IgnoreNotMatch);
        //System.out.println(jsonObject.toJSONString(jsonObject, SerializerFeature.WriteMapNullValue));
        //System.out.println(jsonObject.toJSONString(SerializerFeature.WriteMapNullValue));
        //System.out.println(jsonObject.toJSONString());

        /*String apiVersion = "v1";
        String path = "/v1/fprz/aafdkkf";
        String apiHost = "http://127.0.0.1:8081";
        if (path.toLowerCase().startsWith("/v")) {
            apiVersion = path.substring(1, 3);
            System.out.println(apiVersion);
        }

        String url = apiHost;
        if(apiHost.toLowerCase().indexOf("/v") == -1){
            url += "/" + apiVersion;
        } else {
            url = url.substring(0, url.indexOf("/v")) + "/" + apiVersion;
        }
        url += "/AGG/oauth2/login";
        System.out.println(url);*/

    }


}
