package com.ttk.agg.openapi.sdk.dto;

public class CallResult<T> {
    private final boolean success;
    private final ExceptionResult exceptionResult;
    private final T data;

    public CallResult(boolean success, ExceptionResult exceptionResult, T data) {
        this.success = success;
        this.exceptionResult = exceptionResult;
        this.data = data;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public ExceptionResult getExceptionResult() {
        return this.exceptionResult;
    }

    public T getData() {
        return this.data;
    }

    public static <T> CallResult<T> success() {
        return new CallResult<>(true, null, null);
    }

    public static <T> CallResult<T> success(T data) {
        return new CallResult<>(true, null, data);
    }

    public static <T> CallResult<T> fail(ExceptionResult exceptionResult) {
        return new CallResult<>(false, exceptionResult, null);
    }

    public String toString() {
        return "CallResult(success=" + isSuccess() + ", exceptionResult=" + getExceptionResult() + ", data=" + getData() + ")";
    }
}