package com.ttk.agg.openapi.sdk.dto;

import java.util.Date;

public class InvoiceInspectionParamBody {

    /**
     * 发票代码
     */
    private String invoiceCode;

    /**
     * 发票号码
     * 必填项，8位数字的发票号码；数电发票传20位发票号码（09、90、81、82、51、61）
     */
    private String invoiceNumber;

    /**
     * 开票日期
     * 必填项，格式为YYYY-MM-DD
     */
    private String billingDate;

    /**
     * 发票金额
     * 发票类型为 01、03、15、20时不可为空；
     * 01、03、20填写发票不含税金额；
     * 15填写发票车价合计。
     * 数电发票（09、90、81、82、51、61）价税合计。
     */
    private String totalAmount;

    /**
     * 校验码
     * 发票类型为04、10、11、14、86时此项不可为空。
     * 数电纸质普票校验码为数电发票号码后六位。
     */
    private String checkCode;

    /**
     * 客户请求流水号
     * YYYYMMDD+发票代码+发票号码+8位随机数
     */
    private String flowId;

    // Getters and Setters

    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public String getBillingDate() {
        return billingDate;
    }

    public void setBillingDate(String billingDate) {
        this.billingDate = billingDate;
    }

    public String getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getCheckCode() {
        return checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }

    public String getFlowId() {
        return flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }
}
