package com.ttk.agg.openapi.sdk.enums;

import com.ttk.agg.openapi.sdk.inspect.*;
import org.apache.http.util.TextUtils;

import static org.apache.http.util.TextUtils.isBlank;

public enum InspectReturnMappingEnum {
    VAT_SPECIAL("01", "增值税专用发票", SpecialInvoiceInfo.class),
    VAT_TRANSPORT("02", "货运运输业增值税专用发票", TransportInvoiceInfo.class),
    VAT_VEHICLE("03", "机动车销售统一发票", VehicleInvoiceInfo.class),
    VAT_NORMAL("04", "增值税普通发票", NormalInvoiceInfo.class),
    VAT_ELEC_NORMAL("10", "增值税电子普通发票", ENormalInvoiceInfo.class),
    VAT_ROLL_NORMAL("11", "增值税普通发票（卷式）", RollInvoiceInfo.class),
    VAT_TOLL("14", "增值税电子普通发票（通行费）", TollInvoiceInfo.class),
    VAT_USED_CAR("15", "二手车销售统一发票", UsedCarInvoiceInfo.class),
    VAT_ELEC_SPECIAL("20", "增值税电子专用发票", ESpecialInvoiceInfo.class),
    ALL_ELEC_SPECIAL("08xdp", "全电专票", ESpecialInvoiceInfo.class),
    ALL_ELEC_NORMAL("10xdp", "全电普票", ENormalInvoiceInfo.class),
    QD_ZP("09", "全电专票", ESpecialInvoiceInfo.class),
    QD_ZZP("85", "全电纸质专票", SpecialInvoiceInfo.class),
    QD_PP("90", "全电普票", ENormalInvoiceInfo.class),
    QD_ZPP("86", "全电纸质专票", NormalInvoiceInfo.class),
    QD_TL("51", "全电发票（铁路电子客票）", ESpecialInvoiceInfo.class),
    QD_HK("61", "电子发票（航空运输客票电子行程单）", ESpecialInvoiceInfo.class),
    UNKNOWN("99", "未知发票类型", NormalInvoiceInfo.class);

    private String type;
    private String name;
    private Class clazz;

    private InspectReturnMappingEnum(String type, String name, Class clazz) {
        this.type = type;
        this.name = name;
        this.clazz = clazz;
    }

    public static InspectReturnMappingEnum of(String key) {
        if (TextUtils.isBlank(key)) {
            return UNKNOWN;
        } else {
            InspectReturnMappingEnum[] var4;
            int var3 = (var4 = values()).length;

            for(int var2 = 0; var2 < var3; ++var2) {
                InspectReturnMappingEnum mappingEnum = var4[var2];
                if (mappingEnum.getType().equals(key)) {
                    return mappingEnum;
                }
            }

            return UNKNOWN;
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }
}
