/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry;

import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.retry.AsyncRetryBlock;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.event.RetryEvent;
import io.github.resilience4j.retry.event.RetryOnErrorEvent;
import io.github.resilience4j.retry.event.RetryOnIgnoredErrorEvent;
import io.github.resilience4j.retry.event.RetryOnRetryEvent;
import io.github.resilience4j.retry.event.RetryOnSuccessEvent;
import io.github.resilience4j.retry.internal.AsyncRetryImpl;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;

public interface AsyncRetry {
    public String getName();

    public EventPublisher getEventPublisher();

    public Context context();

    public RetryConfig getRetryConfig();

    public static AsyncRetry of(String id, RetryConfig retryConfig) {
        return new AsyncRetryImpl(id, retryConfig);
    }

    public static AsyncRetry of(String id, Supplier<RetryConfig> retryConfigSupplier) {
        return AsyncRetry.of(id, retryConfigSupplier.get());
    }

    public static AsyncRetry ofDefaults(String id) {
        return AsyncRetry.of(id, RetryConfig.ofDefaults());
    }

    default public <T> CompletionStage<T> executeCompletionStage(ScheduledExecutorService scheduler, Supplier<CompletionStage<T>> supplier) {
        return AsyncRetry.decorateCompletionStage(this, scheduler, supplier).get();
    }

    public static <T> Supplier<CompletionStage<T>> decorateCompletionStage(AsyncRetry retry, ScheduledExecutorService scheduler, Supplier<CompletionStage<T>> supplier) {
        return () -> {
            CompletableFuture promise = new CompletableFuture();
            AsyncRetryBlock block = new AsyncRetryBlock(scheduler, retry.context(), supplier, promise);
            block.run();
            return promise;
        };
    }

    public Metrics getMetrics();

    public static interface EventPublisher
    extends io.github.resilience4j.core.EventPublisher<RetryEvent> {
        public EventPublisher onRetry(EventConsumer<RetryOnRetryEvent> var1);

        public EventPublisher onSuccess(EventConsumer<RetryOnSuccessEvent> var1);

        public EventPublisher onError(EventConsumer<RetryOnErrorEvent> var1);

        public EventPublisher onIgnoredError(EventConsumer<RetryOnIgnoredErrorEvent> var1);
    }

    public static interface Context<T> {
        public void onSuccess();

        public long onError(Throwable var1);

        public long onResult(T var1);
    }

    public static interface Metrics {
        public long getNumberOfSuccessfulCallsWithoutRetryAttempt();

        public long getNumberOfFailedCallsWithoutRetryAttempt();

        public long getNumberOfSuccessfulCallsWithRetryAttempt();

        public long getNumberOfFailedCallsWithRetryAttempt();
    }
}

