/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.monitoring.endpoint;

import io.github.resilience4j.consumer.CircularEventConsumer;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.retry.event.RetryEvent;
import io.github.resilience4j.retry.monitoring.endpoint.RetryEventDTOFactory;
import io.github.resilience4j.retry.monitoring.endpoint.RetryEventsEndpointResponse;
import io.vavr.collection.List;
import java.util.Comparator;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="retryevents")
public class RetryEventsEndpoint {
    private final EventConsumerRegistry<RetryEvent> syncRetryEventConsumerRegistry;

    public RetryEventsEndpoint(EventConsumerRegistry<RetryEvent> eventConsumerRegistry) {
        this.syncRetryEventConsumerRegistry = eventConsumerRegistry;
    }

    @ReadOperation
    public RetryEventsEndpointResponse getAllRetryEvenets() {
        return new RetryEventsEndpointResponse(this.syncRetryEventConsumerRegistry.getAllEventConsumer().flatMap(CircularEventConsumer::getBufferedEvents).sorted(Comparator.comparing(RetryEvent::getCreationTime)).map(RetryEventDTOFactory::createRetryEventDTO).toJavaList());
    }

    @ReadOperation
    public RetryEventsEndpointResponse getEventsFilteredByRetryrName(@Selector String name) {
        return new RetryEventsEndpointResponse(this.getRetryEventCircularEventConsumer(name).filter(event -> event.getName().equals(name)).map(RetryEventDTOFactory::createRetryEventDTO).toJavaList());
    }

    @ReadOperation
    public RetryEventsEndpointResponse getEventsFilteredByRetryNameAndEventType(@Selector String name, @Selector String eventType) {
        return new RetryEventsEndpointResponse(this.getRetryEventCircularEventConsumer(name).filter(event -> event.getName().equals(name)).filter(event -> event.getEventType() == RetryEvent.Type.valueOf((String)eventType.toUpperCase())).map(RetryEventDTOFactory::createRetryEventDTO).toJavaList());
    }

    private List<RetryEvent> getRetryEventCircularEventConsumer(String name) {
        CircularEventConsumer syncEvents = this.syncRetryEventConsumerRegistry.getEventConsumer(name);
        if (syncEvents != null) {
            return syncEvents.getBufferedEvents();
        }
        return List.empty();
    }
}

