/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.model;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.taotao.cloud.common.model.BaseQuery;
import com.taotao.cloud.common.utils.AntiSqlFilterUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

@Schema(name="PageQuery", description="\u901a\u7528\u5206\u9875\u67e5\u8be2Query")
public record PageQuery<QueryDTO>(@Schema(description="\u5f53\u524d\u7b2c\u51e0\u9875\uff0c\u9ed8\u8ba41", example="1", required=true) @NotNull(message="\u5f53\u524d\u9875\u663e\u793a\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a") @Min(value=0L) @Max(value=0x7FFFFFFFL) @NotNull(message="\u5f53\u524d\u9875\u663e\u793a\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a") @Min(value=0L) @Max(value=0x7FFFFFFFL) Integer currentPage, @Schema(description="\u6bcf\u9875\u663e\u793a\u6761\u6570\uff0c\u9ed8\u8ba410", example="10", required=true) @NotNull(message="\u6bcf\u9875\u6570\u636e\u663e\u793a\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a") @Min(value=5L) @Max(value=100L) @NotNull(message="\u6bcf\u9875\u6570\u636e\u663e\u793a\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a") @Min(value=5L) @Max(value=100L) Integer pageSize, @Schema(description="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") QueryDTO query) implements Serializable
{
    private static final long serialVersionUID = -2483306509077581330L;

    @JsonIgnore
    public <T> IPage<T> buildMpPage() {
        PageQuery params = this;
        QueryDTO query = params.query();
        Page page = new Page((long)params.currentPage().intValue(), (long)params.pageSize().intValue());
        if (query instanceof BaseQuery) {
            BaseQuery baseQuery = (BaseQuery)query;
            if (CollectionUtil.isEmpty(baseQuery.sortQuery())) {
                return page;
            }
            ArrayList orders = new ArrayList();
            baseQuery.sortQuery().forEach(sortDTO -> {
                String filed = sortDTO.filed();
                String order = sortDTO.order();
                String underlineSort = StrUtil.toUnderlineCase((CharSequence)filed);
                if (!StrUtil.equalsAny((CharSequence)filed, (CharSequence[])new CharSequence[]{"createTime", "updateTime"})) {
                    underlineSort = AntiSqlFilterUtils.getSafeValue(underlineSort);
                }
                if (StrUtil.equalsAny((CharSequence)order, (CharSequence[])new CharSequence[]{"asc"})) {
                    orders.add(OrderItem.asc((String)underlineSort));
                } else {
                    orders.add(OrderItem.desc((String)underlineSort));
                }
            });
            page.setOrders(orders);
        }
        return page;
    }

    @JsonIgnore
    public Pageable buildJpaPage() {
        PageQuery params = this;
        QueryDTO query = params.query();
        if (query instanceof BaseQuery) {
            BaseQuery baseQuery = (BaseQuery)query;
            if (CollectionUtil.isEmpty(baseQuery.sortQuery())) {
                return PageRequest.of((int)params.currentPage(), (int)params.pageSize());
            }
            ArrayList orders = new ArrayList();
            baseQuery.sortQuery().forEach(sortDTO -> {
                String filed = sortDTO.filed();
                String order = sortDTO.order();
                String underlineSort = StrUtil.toUnderlineCase((CharSequence)filed);
                if (!StrUtil.equalsAny((CharSequence)filed, (CharSequence[])new CharSequence[]{"createTime", "updateTime"})) {
                    underlineSort = AntiSqlFilterUtils.getSafeValue(underlineSort);
                }
                if (StrUtil.equalsAny((CharSequence)order, (CharSequence[])new CharSequence[]{"asc"})) {
                    orders.add(Sort.Order.asc((String)underlineSort));
                } else {
                    orders.add(Sort.Order.desc((String)underlineSort));
                }
            });
            return PageRequest.of((int)params.currentPage(), (int)params.pageSize(), (Sort)Sort.by(orders));
        }
        return PageRequest.of((int)params.currentPage(), (int)params.pageSize());
    }

    @JsonIgnore
    public long offset() {
        long current = this.currentPage.intValue();
        if (current <= 1L) {
            return 0L;
        }
        return (current - 1L) * (long)this.pageSize.intValue();
    }
}

