/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.model;

import cn.hutool.core.util.StrUtil;
import com.taotao.cloud.common.enums.ResultEnum;
import com.taotao.cloud.common.utils.IdGeneratorUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.slf4j.MDC;

@Schema(description="\u8fd4\u56de\u7ed3\u679c\u5bf9\u8c61")
public record Result<T>(@Schema(description="\u72b6\u6001\u7801") int code, @Schema(description="\u8fd4\u56de\u6570\u636e") T data, @Schema(description="\u662f\u5426\u6210\u529f") boolean success, @Schema(description="\u5f02\u5e38\u6d88\u606f\u4f53") String errorMsg, @Schema(description="\u8bf7\u6c42id") String requestId, @Schema(description="\u8bf7\u6c42\u7ed3\u675f\u65f6\u95f4") LocalDateTime timestamp) implements Serializable
{
    private static final long serialVersionUID = -3685249101751401211L;

    public static <T> Result<T> of(int code, T data, boolean success, String errorMsg) {
        return new Result<T>(code, data, success, errorMsg, StrUtil.isNotBlank((CharSequence)MDC.get((String)"taotao-cloud-trace-id")) ? MDC.get((String)"taotao-cloud-trace-id") : IdGeneratorUtil.getIdStr(), LocalDateTime.now());
    }

    public static <T> Result<T> success(T data) {
        return Result.of(ResultEnum.SUCCESS.getCode(), data, true, "");
    }

    public static <T> Result<T> success(T data, int code) {
        return Result.of(code, data, true, "");
    }

    public static Result<String> success(String data, ResultEnum resultEnum) {
        return Result.of(resultEnum.getCode(), resultEnum.getDesc(), true, "");
    }

    public static Result<String> fail() {
        return Result.of(ResultEnum.ERROR.getCode(), null, false, ResultEnum.ERROR.getDesc());
    }

    public static <T> Result<T> fail(String errorMsg) {
        return Result.of(ResultEnum.ERROR.getCode(), null, false, errorMsg);
    }

    public static <T> Result<T> fail(String data, int code) {
        return Result.of(code, null, false, data);
    }

    public static Result<String> fail(ResultEnum resultEnum) {
        return Result.of(resultEnum.getCode(), null, false, resultEnum.getDesc());
    }

    public static <T> Result<T> fail(Throwable throwable) {
        return Result.of(ResultEnum.ERROR.getCode(), null, false, throwable.getMessage());
    }

    public static <T> Result<T> validFail(ResultEnum resultEnum) {
        return Result.of(resultEnum.getCode(), null, false, resultEnum.getDesc());
    }

    public static <T> Result<T> validFail(String errorMsg, Object ... args) {
        return Result.of(ResultEnum.ERROR.getCode(), null, false, errorMsg);
    }

    public static <T> Result<T> validFail(String errorMsg) {
        return Result.of(ResultEnum.ERROR.getCode(), null, false, errorMsg);
    }
}

