/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.model;

import cn.hutool.core.collection.CollUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class SecurityUser
implements UserDetails,
Serializable {
    private static final long serialVersionUID = -3685249101751401211L;
    private static final String ROLE_PREFIX = "ROLE_";
    private Long userId;
    private String username;
    private String password;
    private String deptId;
    private String jobId;
    private String email;
    private String phone;
    private String avatar;
    private String lockFlag;
    private String delFlag;
    private String nickname;
    private Integer sex;
    private Integer type;
    private Set<String> permissions;
    private Set<String> roles;

    public SecurityUser() {
    }

    public SecurityUser(Long userId, String username, String password, Set<String> permissions, Set<String> roles) {
        this.userId = userId;
        this.username = username;
        this.password = password;
        this.permissions = permissions;
        this.roles = roles;
    }

    @JsonIgnore
    public Collection<? extends GrantedAuthority> getAuthorities() {
        HashSet authorities = new HashSet();
        if (!CollUtil.isEmpty(this.roles)) {
            this.roles.parallelStream().forEach(role -> authorities.add(new SimpleGrantedAuthority(ROLE_PREFIX + role)));
        }
        if (!CollUtil.isEmpty(this.permissions)) {
            this.permissions.parallelStream().forEach(permission -> authorities.add(new SimpleGrantedAuthority(permission)));
        }
        return authorities;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public SecurityUser(Long userId) {
        this.userId = userId;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public void setDeptId(String deptId) {
        this.deptId = deptId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getLockFlag() {
        return this.lockFlag;
    }

    public void setLockFlag(String lockFlag) {
        this.lockFlag = lockFlag;
    }

    public String getDelFlag() {
        return this.delFlag;
    }

    public void setDelFlag(String delFlag) {
        this.delFlag = delFlag;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public Integer getSex() {
        return this.sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<String> permissions) {
        this.permissions = permissions;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public static SecurityUserBuilder builder() {
        return new SecurityUserBuilder();
    }

    public static final class SecurityUserBuilder {
        private Long userId;
        private String username;
        private String password;
        private String deptId;
        private String jobId;
        private String email;
        private String phone;
        private String avatar;
        private String lockFlag;
        private String delFlag;
        private String nickname;
        private Integer sex;
        private Integer type;
        private Set<String> permissions;
        private Set<String> roles;

        private SecurityUserBuilder() {
        }

        public static SecurityUserBuilder aSecurityUser() {
            return new SecurityUserBuilder();
        }

        public SecurityUserBuilder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public SecurityUserBuilder username(String username) {
            this.username = username;
            return this;
        }

        public SecurityUserBuilder password(String password) {
            this.password = password;
            return this;
        }

        public SecurityUserBuilder deptId(String deptId) {
            this.deptId = deptId;
            return this;
        }

        public SecurityUserBuilder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public SecurityUserBuilder email(String email) {
            this.email = email;
            return this;
        }

        public SecurityUserBuilder phone(String phone) {
            this.phone = phone;
            return this;
        }

        public SecurityUserBuilder avatar(String avatar) {
            this.avatar = avatar;
            return this;
        }

        public SecurityUserBuilder lockFlag(String lockFlag) {
            this.lockFlag = lockFlag;
            return this;
        }

        public SecurityUserBuilder delFlag(String delFlag) {
            this.delFlag = delFlag;
            return this;
        }

        public SecurityUserBuilder nickname(String nickname) {
            this.nickname = nickname;
            return this;
        }

        public SecurityUserBuilder sex(Integer sex) {
            this.sex = sex;
            return this;
        }

        public SecurityUserBuilder type(Integer type) {
            this.type = type;
            return this;
        }

        public SecurityUserBuilder permissions(Set<String> permissions) {
            this.permissions = permissions;
            return this;
        }

        public SecurityUserBuilder roles(Set<String> roles) {
            this.roles = roles;
            return this;
        }

        public SecurityUser build() {
            SecurityUser securityUser = new SecurityUser();
            securityUser.setUserId(this.userId);
            securityUser.setUsername(this.username);
            securityUser.setPassword(this.password);
            securityUser.setDeptId(this.deptId);
            securityUser.setJobId(this.jobId);
            securityUser.setEmail(this.email);
            securityUser.setPhone(this.phone);
            securityUser.setAvatar(this.avatar);
            securityUser.setLockFlag(this.lockFlag);
            securityUser.setDelFlag(this.delFlag);
            securityUser.setNickname(this.nickname);
            securityUser.setSex(this.sex);
            securityUser.setType(this.type);
            securityUser.setPermissions(this.permissions);
            securityUser.setRoles(this.roles);
            return securityUser;
        }
    }
}

