/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.utils;

import com.taotao.cloud.common.exception.BaseException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.web.context.ConfigurableWebServerApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class ContextUtil {
    public static Class<?> mainClass;
    public static ConfigurableApplicationContext applicationContext;

    private ContextUtil() {
    }

    public static void setApplicationContext(ConfigurableApplicationContext applicationContext) {
        ContextUtil.applicationContext = applicationContext;
    }

    public static ConfigurableApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static boolean isWeb() {
        return ContextUtil.getConfigurableWebServerApplicationContext() != null;
    }

    public static ConfigurableWebServerApplicationContext getConfigurableWebServerApplicationContext() {
        ConfigurableApplicationContext context = ContextUtil.getApplicationContext();
        if (context instanceof ConfigurableWebServerApplicationContext) {
            return (ConfigurableWebServerApplicationContext)context;
        }
        return null;
    }

    public static <T> T getBean(Class<T> type, boolean required) {
        ConfigurableApplicationContext applicationContext = ContextUtil.getApplicationContext();
        if (type != null && applicationContext != null) {
            try {
                if (required) {
                    return (T)applicationContext.getBean(type);
                }
                if (applicationContext.getBeansOfType(type).size() > 0) {
                    return (T)applicationContext.getBean(type);
                }
            }
            catch (NoSuchBeanDefinitionException e) {
                return null;
            }
        }
        return null;
    }

    public static Object getBean(String type, boolean required) {
        ConfigurableApplicationContext applicationContext = ContextUtil.getApplicationContext();
        if (type != null && applicationContext != null) {
            if (required) {
                return applicationContext.getBean(type);
            }
            if (applicationContext.containsBean(type)) {
                return applicationContext.getBean(type);
            }
        }
        return null;
    }

    public static String getBeanDefinitionText() {
        ConfigurableApplicationContext applicationContext = ContextUtil.getApplicationContext();
        Object[] beans = applicationContext.getBeanDefinitionNames();
        Arrays.sort(beans);
        StringBuilder sb = new StringBuilder();
        for (Object bean : beans) {
            sb.append((String)bean).append(" -> ").append(ContextUtil.getApplicationContext().getBean((String)bean).getClass());
        }
        return sb.toString();
    }

    public static Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> anno) {
        Map map;
        try {
            map = applicationContext.getBeansWithAnnotation(anno);
        }
        catch (Exception e) {
            map = null;
        }
        return map;
    }

    public static <T> List<T> getBeansOfType(Class<T> clazz) {
        Map map;
        try {
            map = applicationContext.getBeansOfType(clazz);
        }
        catch (Exception e) {
            map = null;
        }
        return map == null ? null : new ArrayList(map.values());
    }

    public static void registerBean(String name, Class clazz, Object ... args) {
        ConfigurableApplicationContext applicationContext = ContextUtil.getApplicationContext();
        ContextUtil.checkRegisterBean((ApplicationContext)applicationContext, name, clazz);
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition((Class)clazz);
        for (Object arg : args) {
            beanDefinitionBuilder.addConstructorArgValue(arg);
        }
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)applicationContext.getBeanFactory();
        beanFactory.registerBeanDefinition(name, (BeanDefinition)beanDefinition);
    }

    public static void registerBean(String name, Class clazz, BeanDefinitionBuilder beanDefinitionBuilder) {
        ConfigurableApplicationContext applicationContext = ContextUtil.getApplicationContext();
        ContextUtil.checkRegisterBean((ApplicationContext)applicationContext, name, clazz);
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)applicationContext.getBeanFactory();
        beanFactory.registerBeanDefinition(name, (BeanDefinition)beanDefinition);
    }

    public static void unRegisterBean(String name) {
        ConfigurableApplicationContext applicationContext = ContextUtil.getApplicationContext();
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)applicationContext.getBeanFactory();
        beanFactory.removeBeanDefinition(name);
    }

    public static void checkRegisterBean(ApplicationContext applicationContext, String name, Class clazz) {
        Object bean;
        if (applicationContext.containsBean(name) && !(bean = applicationContext.getBean(name)).getClass().isAssignableFrom(clazz)) {
            throw new BaseException("BeanName \u91cd\u590d\u6ce8\u518c" + name);
        }
    }
}

