/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.utils;

import com.taotao.cloud.common.exception.BaseException;
import com.taotao.cloud.common.utils.LogUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class DateUtil {
    public static final String MATCH_TIME_24 = "(([0-1][0-9])|2[0-3]):[0-5][0-9]:[0-5][0-9]";
    public static final String REGEX_DATA = "^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))";
    public static final String DEFAULT_YEAR_FORMAT = "yyyy";
    public static final String DEFAULT_MONTH_FORMAT = "yyyy-MM";
    public static final String DEFAULT_MONTH_FORMAT_SLASH = "yyyy/MM";
    public static final String DEFAULT_MONTH_FORMAT_EN = "yyyy\u5e74MM\u6708";
    public static final String DEFAULT_WEEK_FORMAT = "yyyy-ww";
    public static final String DEFAULT_WEEK_FORMAT_EN = "yyyy\u5e74ww\u5468";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULT_DATE_FORMAT_EN = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_DATE_TIME_FORMAT_EN = "";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String DAY = "DAY";
    public static final String MONTH = "MONTH";
    public static final String WEEK = "WEEK";
    public static final String DEFAULT_DATE_FORMAT_MATCHES = "^\\d{4}-\\d{1,2}-\\d{1,2}$";
    public static final String DEFAULT_DATE_TIME_FORMAT_MATCHES = "^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}:\\d{1,2}$";
    public static final String DEFAULT_DATE_FORMAT_EN_MATCHES = "^\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5$";
    public static final String DEFAULT_DATE_TIME_FORMAT_EN_MATCHES = "^\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5\\d{1,2}\u65f6\\d{1,2}\u5206\\d{1,2}\u79d2$";
    public static final String SLASH_DATE_FORMAT_MATCHES = "^\\d{4}/\\d{1,2}/\\d{1,2}$";
    public static final String SLASH_DATE_TIME_FORMAT_MATCHES = "^\\d{4}/\\d{1,2}/\\d{1,2} {1}\\d{1,2}:\\d{1,2}:\\d{1,2}$";
    public static final String SLASH_DATE_FORMAT = "yyyy/MM/dd";
    public static final String SLASH_DATE_TIME_FORMAT = "yyyy/MM/dd HH:mm:ss";
    public static final String CRON_FORMAT = "ss mm HH dd MM ? yyyy";
    public static final long MAX_MONTH_DAY = 30L;
    public static final long MAX_3_MONTH_DAY = 90L;
    public static final long MAX_YEAR_DAY = 365L;
    protected static final Map<String, String> DATE_FORMAT = new LinkedHashMap<String, String>(5);

    private DateUtil() {
    }

    public static List<String> getBetweenWeek(Date start, Date end) {
        return DateUtil.getBetweenWeek(DateUtil.date2LocalDate(start), DateUtil.date2LocalDate(end));
    }

    public static List<String> getBetweenWeek(String start, String end) {
        return DateUtil.getBetweenWeek(LocalDate.parse(start), LocalDate.parse(end));
    }

    public static List<String> getBetweenWeek(LocalDate startDate, LocalDate endDate) {
        return DateUtil.getBetweenWeek(startDate, endDate, DEFAULT_WEEK_FORMAT);
    }

    public static List<String> getBetweenWeek(LocalDate startDate, LocalDate endDate, String pattern) {
        ArrayList<String> list = new ArrayList<String>();
        long distance = ChronoUnit.WEEKS.between(startDate, endDate);
        if (distance < 1L) {
            return list;
        }
        Stream.iterate(startDate, d -> d.plusWeeks(1L)).limit(distance + 1L).forEach(f -> list.add(f.format(DateTimeFormatter.ofPattern(pattern))));
        return list;
    }

    public static List<String> getBetweenMonth(Date start, Date end) {
        return DateUtil.getBetweenMonth(DateUtil.date2LocalDate(start), DateUtil.date2LocalDate(end));
    }

    public static List<String> getBetweenMonth(String start, String end) {
        return DateUtil.getBetweenMonth(LocalDate.parse(start), LocalDate.parse(end));
    }

    public static List<String> getBetweenMonth(LocalDate startDate, LocalDate endDate) {
        return DateUtil.getBetweenMonth(startDate, endDate, DEFAULT_MONTH_FORMAT);
    }

    public static List<String> getBetweenMonth(LocalDate startDate, LocalDate endDate, String pattern) {
        ArrayList<String> list = new ArrayList<String>();
        long distance = ChronoUnit.MONTHS.between(startDate, endDate);
        if (distance < 1L) {
            return list;
        }
        Stream.iterate(startDate, d -> d.plusMonths(1L)).limit(distance + 1L).forEach(f -> list.add(f.format(DateTimeFormatter.ofPattern(pattern))));
        return list;
    }

    public static String calculationEn(LocalDateTime startTime, LocalDateTime endTime, List<String> dateList) {
        if (startTime == null) {
            startTime = LocalDateTime.now();
        }
        if (endTime == null) {
            endTime = LocalDateTime.now().plusDays(30L);
        }
        return DateUtil.calculationEn(startTime.toLocalDate(), endTime.toLocalDate(), dateList);
    }

    public static String calculation(LocalDate startDate, LocalDate endDate, List<String> dateList) {
        String dateType;
        long day;
        if (startDate == null) {
            startDate = LocalDate.now();
        }
        if (endDate == null) {
            endDate = LocalDate.now().plusDays(30L);
        }
        if (dateList == null) {
            dateList = new ArrayList<String>();
        }
        if ((day = DateUtil.until(startDate, endDate)) >= 0L && day <= 30L) {
            dateType = DAY;
            dateList.addAll(DateUtil.getBetweenDay(startDate, endDate, DEFAULT_DATE_FORMAT));
        } else if (day > 30L && day <= 90L) {
            dateType = WEEK;
            dateList.addAll(DateUtil.getBetweenWeek(startDate, endDate, DEFAULT_WEEK_FORMAT));
        } else if (day > 90L && day <= 365L) {
            dateType = MONTH;
            dateList.addAll(DateUtil.getBetweenMonth(startDate, endDate, DEFAULT_MONTH_FORMAT));
        } else {
            throw new BaseException("\u65e5\u671f\u53c2\u6570\u53ea\u80fd\u4ecb\u4e8e0-365\u5929\u4e4b\u95f4");
        }
        return dateType;
    }

    public static String calculationEn(LocalDate startDate, LocalDate endDate, List<String> dateList) {
        String dateType;
        long day;
        if (startDate == null) {
            startDate = LocalDate.now();
        }
        if (endDate == null) {
            endDate = LocalDate.now().plusDays(30L);
        }
        if (dateList == null) {
            dateList = new ArrayList<String>();
        }
        if ((day = DateUtil.until(startDate, endDate)) >= 0L && day <= 30L) {
            dateType = DAY;
            dateList.addAll(DateUtil.getBetweenDay(startDate, endDate, DEFAULT_DATE_FORMAT_EN));
        } else if (day > 30L && day <= 90L) {
            dateType = WEEK;
            dateList.addAll(DateUtil.getBetweenWeek(startDate, endDate, DEFAULT_WEEK_FORMAT_EN));
        } else if (day > 90L && day <= 365L) {
            dateType = MONTH;
            dateList.addAll(DateUtil.getBetweenMonth(startDate, endDate, DEFAULT_MONTH_FORMAT_EN));
        } else {
            throw new BaseException("\u65e5\u671f\u53c2\u6570\u53ea\u80fd\u4ecb\u4e8e0-365\u5929\u4e4b\u95f4");
        }
        return dateType;
    }

    public static LocalDateTime getStartTime(String time) {
        Object startTime = time;
        if (time.matches("^\\d{4}-\\d{1,2}$")) {
            startTime = time + "-01 00:00:00";
        } else if (time.matches(DEFAULT_DATE_FORMAT_MATCHES)) {
            startTime = time + " 00:00:00";
        } else if (time.matches("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}$")) {
            startTime = time + ":00";
        } else if (time.matches("^\\d{4}-\\d{1,2}-\\d{1,2}T{1}\\d{1,2}:\\d{1,2}:\\d{1,2}.\\d{3}Z$")) {
            startTime = time.replace("T", " ").substring(0, time.indexOf(46));
        }
        return LocalDateTime.parse((CharSequence)startTime, DateTimeFormatter.ofPattern(DEFAULT_DATE_TIME_FORMAT));
    }

    public static LocalDateTime getEndTime(String time) {
        Object startTime = time;
        if (time.matches("^\\d{4}-\\d{1,2}$")) {
            Date date = DateUtil.parse(time, DEFAULT_MONTH_FORMAT);
            date = DateUtil.getLastDateOfMonth(date);
            startTime = DateUtil.formatAsDate(date) + " 23:59:59";
        } else if (time.matches(DEFAULT_DATE_FORMAT_MATCHES)) {
            startTime = time + " 23:59:59";
        } else if (time.matches("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}$")) {
            startTime = time + ":59";
        } else if (time.matches("^\\d{4}-\\d{1,2}-\\d{1,2}T{1}\\d{1,2}:\\d{1,2}:\\d{1,2}.\\d{3}Z$")) {
            if ((time = time.replace("T", " ").substring(0, time.indexOf(46))).endsWith("00:00:00")) {
                time = time.replace("00:00:00", "23:59:59");
            }
            startTime = time;
        }
        return LocalDateTime.parse((CharSequence)startTime, DateTimeFormatter.ofPattern(DEFAULT_DATE_TIME_FORMAT));
    }

    public static boolean between(LocalTime from, LocalTime to) {
        if (from == null) {
            throw new IllegalArgumentException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (to == null) {
            throw new IllegalArgumentException("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LocalTime now = LocalTime.now();
        return now.isAfter(from) && now.isBefore(to);
    }

    public static Date getDate2359(LocalDateTime value) {
        return DateUtil.getDate2359(value.toLocalDate());
    }

    public static Date getDate2359(Date value) {
        return DateUtil.getDate2359(DateUtil.date2LocalDate(value));
    }

    public static Date getDate2359(LocalDate value) {
        LocalDateTime dateEnd = LocalDateTime.of(value, LocalTime.MAX);
        return DateUtil.localDateTime2Date(dateEnd);
    }

    public static Date localDateTime2Date(LocalDateTime localDateTime) {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        return Date.from(zdt.toInstant());
    }

    public static LocalDateTime date2LocalDateTime(Date date) {
        if (date == null) {
            return LocalDateTime.now();
        }
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalDateTime();
    }

    public static LocalDate date2LocalDate(Date date) {
        if (date == null) {
            return LocalDate.now();
        }
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalDate();
    }

    public static LocalTime date2LocalTime(Date date) {
        if (date == null) {
            return LocalTime.now();
        }
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalTime();
    }

    public static LocalDateTime getDateTimeOfTimestamp(long epochMilli) {
        Instant instant = Instant.ofEpochMilli(epochMilli);
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static LocalDateTime getDateTimeOfSecond(long epochSecond) {
        Instant instant = Instant.ofEpochSecond(epochSecond);
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static long until(Date endDate) {
        return LocalDateTime.now().until(DateUtil.date2LocalDateTime(endDate), ChronoUnit.DAYS);
    }

    public static long until(Date startDate, Date endDate) {
        return DateUtil.date2LocalDateTime(startDate).until(DateUtil.date2LocalDateTime(endDate), ChronoUnit.DAYS);
    }

    public static long until(LocalDateTime startDate, LocalDateTime endDate) {
        return startDate.until(endDate, ChronoUnit.DAYS);
    }

    public static long until(LocalDate startDate, LocalDate endDate) {
        return startDate.until(endDate, ChronoUnit.DAYS);
    }

    public static List<String> getBetweenDay(Date start, Date end) {
        return DateUtil.getBetweenDay(DateUtil.date2LocalDate(start), DateUtil.date2LocalDate(end));
    }

    public static List<String> getBetweenDay(String start, String end) {
        return DateUtil.getBetweenDay(LocalDate.parse(start), LocalDate.parse(end));
    }

    public static List<String> getBetweenDay(LocalDate startDate, LocalDate endDate) {
        return DateUtil.getBetweenDay(startDate, endDate, DEFAULT_DATE_FORMAT);
    }

    public static List<String> getBetweenDayEn(LocalDate startDate, LocalDate endDate) {
        return DateUtil.getBetweenDay(startDate, endDate, DEFAULT_DATE_FORMAT_EN);
    }

    public static List<String> getBetweenDay(LocalDate startDate, LocalDate endDate, String pattern) {
        if (pattern == null) {
            pattern = DEFAULT_DATE_FORMAT;
        }
        ArrayList<String> list = new ArrayList<String>();
        long distance = ChronoUnit.DAYS.between(startDate, endDate);
        if (distance < 1L) {
            return list;
        }
        String finalPattern = pattern;
        Stream.iterate(startDate, d -> d.plusDays(1L)).limit(distance + 1L).forEach(f -> list.add(f.format(DateTimeFormatter.ofPattern(finalPattern))));
        return list;
    }

    public static LocalDate parse(String source) {
        String sourceTrim = source.trim();
        Set<Map.Entry<String, String>> entries = DATE_FORMAT.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            if (!sourceTrim.matches(entry.getValue())) continue;
            return LocalDate.parse(source, DateTimeFormatter.ofPattern(entry.getKey()));
        }
        throw new BaseException("\u89e3\u6790\u65e5\u671f\u5931\u8d25, \u8bf7\u4f20\u9012\u6b63\u786e\u7684\u65e5\u671f\u683c\u5f0f");
    }

    public static String getCron(Date date) {
        return DateUtil.format(date, CRON_FORMAT);
    }

    public static String getCron(LocalDateTime date) {
        return DateUtil.format(date, CRON_FORMAT);
    }

    public static String format(LocalDateTime date, String pattern) {
        if (date == null) {
            date = LocalDateTime.now();
        }
        if (pattern == null) {
            pattern = DEFAULT_MONTH_FORMAT;
        }
        return date.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String format(LocalDate date, String pattern) {
        if (date == null) {
            date = LocalDate.now();
        }
        if (pattern == null) {
            pattern = DEFAULT_MONTH_FORMAT;
        }
        return date.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String format(Date d, String f) {
        Date date = d;
        String format = f;
        if (date == null) {
            date = new Date();
        }
        if (format == null) {
            format = DEFAULT_DATE_TIME_FORMAT;
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static String formatAsDate(LocalDateTime date) {
        return DateUtil.format(date, DEFAULT_DATE_FORMAT);
    }

    public static String formatAsDate(LocalDate date) {
        return DateUtil.format(date, DEFAULT_DATE_FORMAT);
    }

    public static String formatAsDateEn(LocalDateTime date) {
        return DateUtil.format(date, DEFAULT_DATE_FORMAT_EN);
    }

    public static String formatAsYearMonth(LocalDateTime date) {
        return DateUtil.format(date, DEFAULT_MONTH_FORMAT);
    }

    public static String formatAsYearMonthEn(LocalDateTime date) {
        return DateUtil.format(date, DEFAULT_MONTH_FORMAT_EN);
    }

    public static String formatAsYearWeek(LocalDateTime date) {
        return DateUtil.format(date, DEFAULT_WEEK_FORMAT);
    }

    public static String formatAsYearWeekEn(LocalDateTime date) {
        return DateUtil.format(date, DEFAULT_WEEK_FORMAT_EN);
    }

    public static String formatAsYearMonth(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(DEFAULT_MONTH_FORMAT);
        return df.format(date);
    }

    public static String formatAsYearWeek(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(DEFAULT_WEEK_FORMAT);
        return df.format(date);
    }

    public static String formatAsTime(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(DEFAULT_TIME_FORMAT);
        return df.format(date);
    }

    public static String formatAsDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        return df.format(date);
    }

    public static String formatAsDateTime(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(DEFAULT_DATE_TIME_FORMAT);
        return df.format(date);
    }

    public static String formatAsDay(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("dd");
        return df.format(date);
    }

    public static Date parse(String dateStr, String format) {
        Date date = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setLenient(false);
        try {
            date = dateFormat.parse(dateStr);
        }
        catch (Exception e) {
            LogUtil.error("DateUtil error", e);
        }
        return date;
    }

    public static Date getLastDateOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 0);
        return calendar.getTime();
    }

    public static Date parseAsDate(String source) {
        String sourceTrim = source.trim();
        Set<Map.Entry<String, String>> entries = DATE_FORMAT.entrySet();
        try {
            for (Map.Entry<String, String> entry : entries) {
                if (!sourceTrim.matches(entry.getValue())) continue;
                return new SimpleDateFormat(entry.getKey()).parse(source);
            }
        }
        catch (ParseException e) {
            throw new BaseException("\u89e3\u6790\u65e5\u671f\u5931\u8d25, \u8bf7\u4f20\u9012\u6b63\u786e\u7684\u65e5\u671f\u683c\u5f0f");
        }
        throw new BaseException("\u89e3\u6790\u65e5\u671f\u5931\u8d25, \u8bf7\u4f20\u9012\u6b63\u786e\u7684\u65e5\u671f\u683c\u5f0f");
    }

    public static Date parseAsDateTime(String dateTime) {
        SimpleDateFormat simpledateformat = new SimpleDateFormat(DEFAULT_DATE_TIME_FORMAT);
        try {
            return simpledateformat.parse(dateTime);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getDate0000(LocalDateTime value) {
        return DateUtil.getDate0000(value.toLocalDate());
    }

    public static Date getDate0000(Date value) {
        return DateUtil.getDate0000(DateUtil.date2LocalDate(value));
    }

    public static Date getDate0000(LocalDate value) {
        LocalDateTime todayStart = LocalDateTime.of(value, LocalTime.MIN);
        return DateUtil.localDateTime2Date(todayStart);
    }

    public static long getTimestamp() {
        return Instant.now().toEpochMilli();
    }

    public static int getCurrentYear() {
        return LocalDate.now().getYear();
    }

    public static String getCurrentYearMonth() {
        return DateUtil.getCurrentDate(DEFAULT_MONTH_FORMAT);
    }

    public static String getCurrentDate() {
        return DateUtil.getCurrentDate(DEFAULT_DATE_FORMAT);
    }

    public static String getNextDate() {
        return DateUtil.getNextDate(DEFAULT_DATE_FORMAT);
    }

    public static String getCurrentTime() {
        return DateUtil.getCurrentTime(DEFAULT_TIME_FORMAT);
    }

    public static String getCurrentDateTime() {
        return DateUtil.getCurrentDateTime(DEFAULT_DATE_TIME_FORMAT);
    }

    public static String getCurrentYearMonthShort() {
        return DateUtil.getCurrentDate("yyyyMM");
    }

    public static String getCurrentDateShort() {
        return DateUtil.getCurrentDate("yyyyMMdd");
    }

    public static String getNextDateShort() {
        return DateUtil.getNextDate("yyyyMMdd");
    }

    public static String getCurrentTimeShort() {
        return DateUtil.getCurrentTime("HHmmss");
    }

    public static String getCurrentDateTimeShort() {
        return DateUtil.getCurrentDateTime("yyyyMMddHHmmss");
    }

    public static String getCurrentDate(String pattern) {
        return LocalDate.now().format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String getNextDate(String pattern) {
        return LocalDate.now().plusDays(1L).format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String getCurrentTime(String pattern) {
        return LocalTime.now().format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String getCurrentDateTime(String pattern) {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDateTime timestampToLocalDateTime(long timestamp) {
        Instant instant = Instant.ofEpochMilli(timestamp);
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static long localDateTimeToTimestamp(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static String formatTimestamp(long timestamp) {
        return DateUtil.formatTimestamp(timestamp, DEFAULT_DATE_TIME_FORMAT);
    }

    public static String formatTimestampShort(long timestamp) {
        return DateUtil.formatTimestamp(timestamp, "yyyyMMddHHmmss");
    }

    public static String formatTimestamp(long timestamp, String pattern) {
        Instant instant = Instant.ofEpochMilli(timestamp);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        return DateUtil.formatLocalDateTime(localDateTime, pattern);
    }

    public static String formatLocalDate(LocalDate localDate) {
        return DateUtil.formatLocalDate(localDate, DEFAULT_DATE_FORMAT);
    }

    public static String formatLocalDateShort(LocalDate localDate) {
        return DateUtil.formatLocalDate(localDate, "yyyyMMdd");
    }

    public static String formatLocalTime(LocalTime localTime) {
        return DateUtil.formatLocalTime(localTime, DEFAULT_TIME_FORMAT);
    }

    public static String formatLocalTimeShort(LocalTime localTime) {
        return DateUtil.formatLocalTime(localTime, "HHmmss");
    }

    public static String formatLocalDateTime(LocalDateTime localDateTime) {
        return DateUtil.formatLocalDateTime(localDateTime, DEFAULT_DATE_TIME_FORMAT);
    }

    public static String formatLocalDateTimeShort(LocalDateTime localDateTime) {
        return DateUtil.formatLocalDateTime(localDateTime, "yyyyMMddHHmmss");
    }

    public static String formatLocalDate(LocalDate localDate, String pattern) {
        return localDate.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String formatLocalTime(LocalTime localTime, String pattern) {
        return localTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String formatLocalDateTime(LocalDateTime localDateTime, String pattern) {
        return localDateTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDate parseLocalDate(String date, String pattern) {
        return LocalDate.parse(date, DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalTime parseLocalTime(String time, String pattern) {
        return LocalTime.parse(time, DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDateTime parseLocalDateTime(String dateTime, String pattern) {
        return LocalDateTime.parse(dateTime, DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDate getCurrentWeekFirstDate() {
        return LocalDate.now().minusWeeks(0L).with(DayOfWeek.MONDAY);
    }

    public static LocalDate getCurrentWeekLastDate() {
        return LocalDate.now().minusWeeks(0L).with(DayOfWeek.SUNDAY);
    }

    public static LocalDate getCurrentMonthFirstDate() {
        return LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
    }

    public static LocalDate getCurrentMonthLastDate() {
        return LocalDate.now().with(TemporalAdjusters.lastDayOfMonth());
    }

    public static LocalDate getWeekFirstDate(String date, String pattern) {
        return DateUtil.parseLocalDate(date, pattern).minusWeeks(0L).with(DayOfWeek.MONDAY);
    }

    public static LocalDate getWeekFirstDate(LocalDate localDate) {
        return localDate.minusWeeks(0L).with(DayOfWeek.MONDAY);
    }

    public static LocalDate getWeekLastDate(String date, String pattern) {
        return DateUtil.parseLocalDate(date, pattern).minusWeeks(0L).with(DayOfWeek.SUNDAY);
    }

    public static LocalDate getWeekLastDate(LocalDate localDate) {
        return localDate.minusWeeks(0L).with(DayOfWeek.SUNDAY);
    }

    public static LocalDate getMonthFirstDate(String date, String pattern) {
        return DateUtil.parseLocalDate(date, pattern).with(TemporalAdjusters.firstDayOfMonth());
    }

    public static LocalDate getMonthFirstDate(LocalDate localDate) {
        return localDate.with(TemporalAdjusters.firstDayOfMonth());
    }

    public static int getCurrentWeek() {
        return LocalDate.now().getDayOfWeek().getValue();
    }

    public static int getWeek(LocalDate localDate) {
        return localDate.getDayOfWeek().getValue();
    }

    public static int getWeek(String date, String pattern) {
        return DateUtil.parseLocalDate(date, pattern).getDayOfWeek().getValue();
    }

    public static long intervalDays(LocalDate startLocalDate, LocalDate endLocalDate) {
        return endLocalDate.toEpochDay() - startLocalDate.toEpochDay();
    }

    public static long intervalHours(LocalDateTime startLocalDateTime, LocalDateTime endLocalDateTime) {
        return Duration.between(startLocalDateTime, endLocalDateTime).toHours();
    }

    public static long intervalMinutes(LocalDateTime startLocalDateTime, LocalDateTime endLocalDateTime) {
        return Duration.between(startLocalDateTime, endLocalDateTime).toMinutes();
    }

    public static long intervalMillis(LocalDateTime startLocalDateTime, LocalDateTime endLocalDateTime) {
        return Duration.between(startLocalDateTime, endLocalDateTime).toMillis();
    }

    public static boolean isCurrentLeapYear() {
        return LocalDate.now().isLeapYear();
    }

    public static boolean isLeapYear(LocalDate localDate) {
        return localDate.isLeapYear();
    }

    public static boolean isToday(LocalDate localDate) {
        return LocalDate.now().equals(localDate);
    }

    public static Long toEpochMilli(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static Long toSelectEpochMilli(LocalDateTime localDateTime, ZoneId zoneId) {
        return localDateTime.atZone(zoneId).toInstant().toEpochMilli();
    }

    public static String getDateAfterDays(int days) {
        Calendar date = Calendar.getInstance();
        date.add(5, days);
        SimpleDateFormat simpleDate = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        return simpleDate.format(date.getTime());
    }

    public static String addDays(String source, int days) {
        Date date = DateUtil.localDateToDate(DateUtil.parseLocalDate(source, DEFAULT_DATE_FORMAT));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, days);
        SimpleDateFormat dateFormat = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        return dateFormat.format(calendar.getTime());
    }

    public static Date localDateToDate(LocalDate localDate) {
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDate.atStartOfDay().atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static boolean isValidate24(String time) {
        Pattern p = Pattern.compile(MATCH_TIME_24);
        return p.matcher(time).matches();
    }

    public static boolean isDate(String date) {
        Pattern pat = Pattern.compile(REGEX_DATA);
        Matcher mat = pat.matcher(date);
        return mat.matches();
    }

    static {
        DATE_FORMAT.put(DEFAULT_DATE_FORMAT, DEFAULT_DATE_FORMAT_MATCHES);
        DATE_FORMAT.put(SLASH_DATE_FORMAT, SLASH_DATE_FORMAT_MATCHES);
        DATE_FORMAT.put(DEFAULT_DATE_FORMAT_EN, DEFAULT_DATE_FORMAT_EN_MATCHES);
    }
}

