/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.utils;

import com.taotao.cloud.common.enums.ResultEnum;
import com.taotao.cloud.common.exception.BaseException;
import com.taotao.cloud.common.utils.LogUtil;
import com.taotao.cloud.common.utils.StringUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class ExceptionUtil {
    private ExceptionUtil() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String trace2String(Throwable t) {
        if (t == null) {
            return "";
        }
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            try {
                t.printStackTrace(pw);
                String string = sw.getBuffer().toString();
                pw.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exp) {
            throw new BaseException(ResultEnum.ERROR, (Throwable)exp);
        }
    }

    public static String trace2String(StackTraceElement[] stackTraceElements) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement stackTraceElemen : stackTraceElements) {
            sb.append(stackTraceElemen.toString()).append("\n");
        }
        return sb.toString();
    }

    private static String lineSeparator() {
        return System.getProperty("line.separator");
    }

    public static String getFullMessage(Throwable e) {
        if (e == null) {
            return "";
        }
        return "\u3010\u8be6\u7ec6\u9519\u8bef\u3011" + ExceptionUtil.lineSeparator() + ExceptionUtil.getDetailMessage(e) + ExceptionUtil.lineSeparator() + "\u3010\u5806\u6808\u6253\u5370\u3011" + ExceptionUtil.lineSeparator() + ExceptionUtil.getFullStackTrace(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFullStackTrace(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            sw.flush();
        }
        finally {
            if (sw != null) {
                try {
                    sw.close();
                }
                catch (IOException iOException) {}
            }
            if (pw != null) {
                pw.close();
            }
        }
        return sw.toString();
    }

    public static String getDetailMessage(Throwable ex) {
        if (ex == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (ex != null) {
            sb.append("\u3010" + ex.getClass().getName() + "\u3011\u2192" + StringUtil.nullToEmpty(ex.getMessage()) + ExceptionUtil.lineSeparator());
            ex = ex.getCause();
        }
        return sb.toString();
    }

    public static void ignoreException(Runnable runnable, boolean isPrintInfo) {
        block2: {
            try {
                runnable.run();
            }
            catch (Exception e) {
                if (isPrintInfo) break block2;
                LogUtil.error(ExceptionUtil.getFullStackTrace(e), new Object[0]);
            }
        }
    }

    public static void ignoreException(Runnable runnable) {
        ExceptionUtil.ignoreException(runnable, false);
    }
}

