/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.utils;

import com.taotao.cloud.common.exception.BaseException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class FileUtil {
    private FileUtil() {
    }

    public static boolean existFile(String filepath) {
        File file = new File(filepath);
        return file.exists();
    }

    public static String getDirectoryPath(String path) {
        File file = new File(path);
        return file.getAbsolutePath();
    }

    public static String getDirectoryPath(Class<?> cls) {
        File file = FileUtil.getJarFile(cls);
        if (file == null) {
            return null;
        }
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        return file.getAbsolutePath();
    }

    public static File getJarFile(Class<?> cls) {
        String path = cls.getProtectionDomain().getCodeSource().getLocation().getFile();
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return new File(path);
    }

    public static Boolean createDirectory(String path) {
        File file = new File(path);
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        if (!file.exists()) {
            return file.mkdirs();
        }
        return false;
    }

    public static void appendAllText(String path, String contents) {
        try {
            File f = new File(path);
            try (FileWriter fw = new FileWriter(f, true);
                 PrintWriter pw = new PrintWriter(fw);){
                pw.println(contents);
                pw.flush();
                fw.flush();
            }
        }
        catch (IOException exp) {
            throw new BaseException("\u8ffd\u52a0\u6587\u4ef6\u5f02\u5e38", (Throwable)exp);
        }
    }

    public static void writeAllText(String path, String contents) {
        block8: {
            try {
                File f = new File(path);
                if (f.exists()) {
                    f.delete();
                }
                if (!f.createNewFile()) break block8;
                try (BufferedWriter output = new BufferedWriter(new FileWriter(f));){
                    output.write(contents);
                }
            }
            catch (IOException exp) {
                throw new BaseException("\u5199\u6587\u4ef6\u5f02\u5e38", (Throwable)exp);
            }
        }
    }

    public static String readAllText(String path) {
        try {
            File f = new File(path);
            if (f.exists()) {
                long fileLength = f.length();
                byte[] fileContent = new byte[(int)fileLength];
                try (FileInputStream in = new FileInputStream(f);){
                    in.read(fileContent);
                }
                return new String(fileContent);
            }
            throw new FileNotFoundException(path);
        }
        catch (IOException exp) {
            throw new BaseException("\u8bfb\u6587\u4ef6\u5f02\u5e38", (Throwable)exp);
        }
    }

    public static String lineSeparator() {
        return System.getProperty("line.separator");
    }

    public static String getFileName(String filePath) {
        String path = filePath.replace("\\\\", "/");
        return path.substring(path.lastIndexOf("/") + 1, path.length());
    }
}

