/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.utils;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.taotao.cloud.common.exception.BaseException;
import com.taotao.cloud.common.json.JacksonModule;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class JsonUtil {
    public static final ObjectMapper MAPPER = new ObjectMapper();

    private JsonUtil() {
    }

    public static String toJSONString(Object object) {
        return JsonUtil.toJSONString(object, false);
    }

    public static String toJSONString(Object object, boolean format) {
        try {
            if (object == null) {
                return "";
            }
            if (object instanceof Number) {
                return object.toString();
            }
            if (object instanceof String) {
                return (String)object;
            }
            if (format) {
                return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(object);
            }
            return MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new BaseException(e.getMessage());
        }
    }

    public static <T> T toObject(String json, Class<T> cls) {
        if (StrUtil.isBlank((CharSequence)json) || cls == null) {
            return null;
        }
        try {
            return (T)MAPPER.readValue(json, cls);
        }
        catch (IOException e) {
            throw new BaseException(e);
        }
    }

    public static <T> T toObject(String json, Class<?> parametrized, Class<?> ... parameterClasses) {
        if (StrUtil.isBlank((CharSequence)json) || parametrized == null) {
            return null;
        }
        try {
            JavaType javaType = MAPPER.getTypeFactory().constructParametricType(parametrized, (Class[])parameterClasses);
            return (T)MAPPER.readValue(json, javaType);
        }
        catch (IOException e) {
            throw new BaseException(e);
        }
    }

    public static <T> T toObject(String json, TypeReference<T> typeReference) {
        if (StrUtil.isBlank((CharSequence)json) || typeReference == null) {
            return null;
        }
        try {
            return (T)MAPPER.readValue(json, typeReference);
        }
        catch (IOException e) {
            throw new BaseException(e);
        }
    }

    public static JsonNode parse(String json) {
        if (StrUtil.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return MAPPER.readTree(json);
        }
        catch (IOException e) {
            throw new BaseException(e);
        }
    }

    public static <K, V> Map<K, V> toMap(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return JsonUtil.toObject((String)object, Map.class);
        }
        return (Map)MAPPER.convertValue(object, Map.class);
    }

    public static <T> List<T> toList(String json) {
        if (StrUtil.isNotBlank((CharSequence)json)) {
            try {
                return (List)MAPPER.readValue(json, List.class);
            }
            catch (JsonProcessingException e) {
                throw new BaseException(e.getMessage());
            }
        }
        return new ArrayList();
    }

    public static <T> List<T> toList(String json, Class<T> cls) {
        if (StrUtil.isBlank((CharSequence)json)) {
            return new ArrayList();
        }
        try {
            JavaType javaType = MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{cls});
            return (List)MAPPER.readValue(json, javaType);
        }
        catch (JsonProcessingException e) {
            throw new BaseException(e.getMessage());
        }
    }

    static {
        MAPPER.findAndRegisterModules();
        MAPPER.setLocale(Locale.CHINA);
        MAPPER.setTimeZone(TimeZone.getTimeZone(ZoneId.systemDefault()));
        MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        MAPPER.configure(JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES.mappedFeature(), true);
        MAPPER.configure(JsonReadFeature.ALLOW_SINGLE_QUOTES.mappedFeature(), true);
        MAPPER.configure(JsonReadFeature.ALLOW_LEADING_ZEROS_FOR_NUMBERS.mappedFeature(), true);
        MAPPER.configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature(), true);
        MAPPER.configure(JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER.mappedFeature(), true);
        MAPPER.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.LOWER_CAMEL_CASE);
        MAPPER.enable(new MapperFeature[]{MapperFeature.USE_STD_BEAN_NAMING});
        MAPPER.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA));
        MAPPER.registerModule((Module)new Jdk8Module());
        MAPPER.registerModule((Module)new JacksonModule());
    }
}

