/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class LogUtil {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final String FQDN = LogUtil.class.getName();

    private LogUtil() {
    }

    public static LocationAwareLogger getLocationAwareLogger() {
        StackTraceElement[] stackTraceElement = Thread.currentThread().getStackTrace();
        StackTraceElement frame = stackTraceElement[stackTraceElement.length - 1];
        return (LocationAwareLogger)LoggerFactory.getLogger((String)(frame.getClassName() + "-" + frame.getMethodName().split("\\$")[0] + "-" + frame.getLineNumber()));
    }

    public static void debug(String msg, Object ... arguments) {
        if (LogUtil.isDebugEnabled()) {
            LogUtil.getLocationAwareLogger().log(null, FQDN, 10, msg, arguments, null);
        }
    }

    public static void info(String msg, Object ... arguments) {
        if (LogUtil.isInfoEnabled()) {
            LogUtil.getLocationAwareLogger().log(null, FQDN, 20, msg, arguments, null);
        }
    }

    public static void started(Class<?> cls, String project, String ... message) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(project).append("] ");
        sb.append("[").append(cls.getName()).append("] ");
        if (message.length > 0) {
            sb.append(Arrays.toString(message) + " ");
        }
        sb.append("started");
        LogUtil.info(sb.toString(), new Object[0]);
    }

    public static void warn(String msg, Object ... arguments) {
        if (LogUtil.isWarnEnabled()) {
            LogUtil.getLocationAwareLogger().log(null, FQDN, 30, msg, arguments, null);
        }
    }

    public static void error(Throwable error, String msg, Object ... arguments) {
        if (LogUtil.isErrorEnabled()) {
            LogUtil.getLocationAwareLogger().log(null, FQDN, 40, msg, arguments, error);
        }
    }

    public static void error(Throwable error) {
        if (LogUtil.isErrorEnabled()) {
            LogUtil.getLocationAwareLogger().log(null, FQDN, 40, null, EMPTY_ARRAY, error);
        }
    }

    public static void error(String msg, Object ... arguments) {
        if (LogUtil.isErrorEnabled()) {
            LogUtil.getLocationAwareLogger().log(null, FQDN, 40, msg, arguments, null);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String exceptionToString(Exception e) {
        if (e == null) {
            return "\u65e0\u5177\u4f53\u5f02\u5e38\u4fe1\u606f";
        }
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter(sw);
            try {
                e.printStackTrace(pw);
                String string = sw.toString();
                pw.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            throwable.printStackTrace(pw);
            String string = sw.toString();
            return string;
        }
    }

    public static int getOperateType(String methodName) {
        if (methodName.startsWith("get")) {
            return 1;
        }
        if (methodName.startsWith("query")) {
            return 1;
        }
        if (methodName.startsWith("find")) {
            return 1;
        }
        if (methodName.startsWith("select")) {
            return 1;
        }
        if (methodName.startsWith("add")) {
            return 2;
        }
        if (methodName.startsWith("save")) {
            return 2;
        }
        if (methodName.startsWith("update")) {
            return 3;
        }
        if (methodName.startsWith("delete")) {
            return 4;
        }
        return 1;
    }

    public static boolean isDebugEnabled() {
        return LogUtil.getLocationAwareLogger().isDebugEnabled();
    }

    public static boolean isInfoEnabled() {
        return LogUtil.getLocationAwareLogger().isInfoEnabled();
    }

    public static boolean isErrorEnabled() {
        return LogUtil.getLocationAwareLogger().isErrorEnabled();
    }

    public static boolean isWarnEnabled() {
        return LogUtil.getLocationAwareLogger().isWarnEnabled();
    }
}

