/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.utils;

import com.taotao.cloud.common.enums.ResultEnum;
import com.taotao.cloud.common.model.Result;
import com.taotao.cloud.common.utils.JsonUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletResponse;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ResponseUtil {
    private ResponseUtil() {
    }

    public static void success(HttpServletResponse response, Object data) throws IOException {
        Result<Object> result = Result.success(data);
        ResponseUtil.writeResponse(response, result);
    }

    public static void fail(HttpServletResponse response, Object data) throws IOException {
        Result result = Result.fail(data.toString());
        ResponseUtil.writeResponse(response, result);
    }

    public static void result(HttpServletResponse response, Result<?> result) throws IOException {
        ResponseUtil.writeResponse(response, result);
    }

    public static void fail(HttpServletResponse response, ResultEnum resultEnum) throws IOException {
        Result<String> result = Result.fail(resultEnum);
        ResponseUtil.writeResponse(response, result);
    }

    private static void writeResponse(HttpServletResponse response, Result<?> result) throws IOException {
        response.setContentType("application/json");
        response.setStatus(HttpStatus.OK.value());
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Type", "application/json;charset=UTF-8");
        try (PrintWriter writer = response.getWriter();){
            ((Writer)writer).write(JsonUtil.toJSONString(result));
            ((Writer)writer).flush();
        }
    }

    public static Mono<Void> success(ServerWebExchange exchange, Object data) {
        Result<Object> result = Result.success(data);
        return ResponseUtil.writeResponse(exchange, result);
    }

    public static Mono<Void> fail(ServerWebExchange exchange, Object data) {
        Result result = Result.fail(data.toString());
        return ResponseUtil.writeResponse(exchange, result);
    }

    public static Mono<Void> result(ServerWebExchange exchange, Result<?> result) {
        return ResponseUtil.writeResponse(exchange, result);
    }

    public static Mono<Void> fail(ServerWebExchange exchange, ResultEnum resultEnum) {
        Result<String> result = Result.fail(resultEnum);
        return ResponseUtil.writeResponse(exchange, result);
    }

    public static Mono<Void> writeResponse(ServerWebExchange exchange, Result<?> result) {
        ServerHttpResponse response = exchange.getResponse();
        response.getHeaders().setAccessControlAllowCredentials(true);
        response.getHeaders().setAccessControlAllowOrigin("*");
        response.setStatusCode(HttpStatus.OK);
        response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        DataBufferFactory dataBufferFactory = response.bufferFactory();
        DataBuffer buffer = dataBufferFactory.wrap(JsonUtil.toJSONString(result).getBytes(Charset.defaultCharset()));
        return response.writeWith((Publisher)Mono.just((Object)buffer)).doOnSuccess(error -> DataBufferUtils.release((DataBuffer)buffer));
    }
}

