/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.utils;

import com.taotao.cloud.common.model.Result;
import com.taotao.cloud.common.model.SecurityUser;
import com.taotao.cloud.common.utils.ContextUtil;
import com.taotao.cloud.common.utils.JsonUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class SecurityUtil {
    private static final String BASIC_ = "Basic ";

    private SecurityUtil() {
    }

    public static void writeResponse(Result<?> result, HttpServletResponse response) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        PrintWriter printWriter = response.getWriter();
        printWriter.write(JsonUtil.toJSONString(result));
        printWriter.flush();
    }

    public static Authentication getAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    public static SecurityUser getUser(Authentication authentication) {
        if (Objects.isNull(authentication)) {
            return null;
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof SecurityUser) {
            return (SecurityUser)principal;
        }
        if (principal instanceof Map) {
            return JsonUtil.toObject(JsonUtil.toJSONString(principal), SecurityUser.class);
        }
        return null;
    }

    public static SecurityUser getUser() {
        Authentication authentication = SecurityUtil.getAuthentication();
        return SecurityUtil.getUser(authentication);
    }

    public static String getUsername() {
        SecurityUser user = SecurityUtil.getUser();
        return Objects.isNull(user) ? "" : user.getUsername();
    }

    public static Long getUserId() {
        SecurityUser user = SecurityUtil.getUser();
        return Objects.isNull(user) ? null : user.getUserId();
    }

    public static boolean validatePass(String newPass, String passwordEncoderOldPass) {
        return SecurityUtil.getPasswordEncoder().matches((CharSequence)newPass, passwordEncoderOldPass);
    }

    public static BCryptPasswordEncoder getPasswordEncoder() {
        BCryptPasswordEncoder passwordEncoder = ContextUtil.getBean(BCryptPasswordEncoder.class, true);
        if (Objects.isNull(passwordEncoder)) {
            passwordEncoder = new BCryptPasswordEncoder();
        }
        return passwordEncoder;
    }

    public static String[] extractHeaderClient(String header) {
        byte[] base64Client = header.substring(BASIC_.length()).getBytes(StandardCharsets.UTF_8);
        byte[] decoded = Base64.getDecoder().decode(base64Client);
        String clientStr = new String(decoded, StandardCharsets.UTF_8);
        String[] clientArr = clientStr.split(":");
        if (clientArr.length != 2) {
            throw new RuntimeException("Invalid basic authentication token");
        }
        return clientArr;
    }

    public static String getUsername(Authentication authentication) {
        Object principal = authentication.getPrincipal();
        String username = null;
        if (principal instanceof SecurityUser) {
            username = ((SecurityUser)principal).getUsername();
        } else if (principal instanceof String) {
            username = (String)principal;
        }
        return username;
    }

    public static String getTenant() {
        return "";
    }

    public static String getClientId() {
        return "";
    }
}

