/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.utils;

import cn.hutool.core.util.StrUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.MDC;

public class TraceUtil {
    private TraceUtil() {
    }

    public static String getTraceId(HttpServletRequest request) {
        String traceId = request.getParameter("taotao-cloud-trace-id");
        if (StrUtil.isBlank((CharSequence)traceId)) {
            traceId = request.getHeader("taotao-cloud-trace-header");
        }
        return traceId;
    }

    public static String getTraceId() {
        return MDC.get((String)"taotao-cloud-trace-id");
    }

    public static void mdcTraceId(String traceId) {
        if (StrUtil.isNotBlank((CharSequence)traceId)) {
            MDC.put((String)"taotao-cloud-trace-id", (String)traceId);
        }
    }

    public static void mdcTenantId(String tenantId) {
        if (StrUtil.isNotBlank((CharSequence)tenantId)) {
            MDC.put((String)"taotao-cloud-tenant-id", (String)tenantId);
        }
    }

    public static void mdcVersion(String version) {
        if (StrUtil.isNotBlank((CharSequence)version)) {
            MDC.put((String)"taotao-cloud-request-version", (String)version);
        }
    }

    public static String getZipkinTraceId(HttpServletRequest request) {
        String zipkinTraceId = request.getParameter("X-B3-TraceId");
        if (StrUtil.isBlank((CharSequence)zipkinTraceId)) {
            zipkinTraceId = request.getHeader("X-B3-TraceId");
        }
        return zipkinTraceId;
    }

    public static String getZipkinSpanId(HttpServletRequest request) {
        String zipkinSpanId = request.getParameter("X-B3-SpanId");
        if (StrUtil.isBlank((CharSequence)zipkinSpanId)) {
            zipkinSpanId = request.getHeader("X-B3-SpanId");
        }
        return zipkinSpanId;
    }

    public static void mdcZipkinTraceId(HttpServletRequest request) {
        String zipkinTraceId = TraceUtil.getZipkinTraceId(request);
        if (StrUtil.isNotBlank((CharSequence)zipkinTraceId)) {
            MDC.put((String)"X-B3-TraceId", (String)zipkinTraceId);
        }
    }

    public static void mdcZipkinSpanId(HttpServletRequest request) {
        String zipkinSpanId = TraceUtil.getZipkinSpanId(request);
        if (StrUtil.isNotBlank((CharSequence)zipkinSpanId)) {
            MDC.put((String)"X-B3-SpanId", (String)zipkinSpanId);
        }
    }
}

