/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.utils;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import com.thoughtworks.xstream.security.AnyTypePermission;
import java.io.File;
import java.nio.charset.StandardCharsets;

public class XmlUtil {
    private static final String XML_TAG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    private XmlUtil() {
    }

    private static XStream getInstance() {
        XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver(StandardCharsets.UTF_8.name())){

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return new MapperWrapper((Mapper)next){

                    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                        if (definedIn == Object.class) {
                            return false;
                        }
                        return super.shouldSerializeMember(definedIn, fieldName);
                    }
                };
            }
        };
        XStream.setupDefaultSecurity((XStream)xStream);
        xStream.setClassLoader(XmlUtil.class.getClassLoader());
        xStream.addPermission(AnyTypePermission.ANY);
        return xStream;
    }

    public static <T> T xml2Obj(String xml, Class<T> clazz) {
        return XmlUtil.xml2Obj(xml, clazz, clazz.getSimpleName());
    }

    public static <T> T xml2Obj(String xml, Class<T> clazz, String rootElement) {
        XStream xStream = XmlUtil.getInstance();
        xStream.processAnnotations(clazz);
        xStream.alias(rootElement, clazz);
        xStream.ignoreUnknownElements();
        Object object = xStream.fromXML(xml);
        return clazz.cast(object);
    }

    public static <T> T xml2Obj(File xml, Class<T> clazz) {
        return XmlUtil.xml2Obj(xml, clazz, clazz.getSimpleName());
    }

    public static <T> T xml2Obj(File xml, Class<T> clazz, String rootElement) {
        XStream xStream = XmlUtil.getInstance();
        xStream.processAnnotations(clazz);
        xStream.alias(rootElement, clazz);
        xStream.ignoreUnknownElements();
        Object object = xStream.fromXML(xml);
        return clazz.cast(object);
    }

    public static String obj2XmlWithTag(Object object) {
        return XmlUtil.obj2XmlWithTag(object, object.getClass().getSimpleName());
    }

    public static String obj2XmlWithTag(Object object, String rootElement) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + XmlUtil.obj2Xml(object, rootElement);
    }

    public static String obj2Xml(Object object) {
        return XmlUtil.obj2Xml(object, object.getClass().getSimpleName());
    }

    public static String obj2Xml(Object object, String rootElement) {
        XStream xStream = XmlUtil.getInstance();
        xStream.alias(rootElement, object.getClass());
        xStream.processAnnotations(object.getClass());
        xStream.ignoreUnknownElements();
        return xStream.toXML(object);
    }
}

