/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.common.utils.secure;

import com.taotao.cloud.common.utils.LogUtil;
import com.taotao.cloud.common.utils.secure.RSAKey;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.EnumMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.commons.lang3.StringUtils;

public class RSAUtil {
    private static final String RSA = "RSA";
    private static final int KEY_SIZE = 1024;

    private RSAUtil() {
    }

    public static Map<RSAKey, String> generatorPairKey() {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(RSA);
            keyPairGen.initialize(1024, new SecureRandom());
            KeyPair keyPair = keyPairGen.generateKeyPair();
            RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
            RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
            String publicKeyString = Base64.getEncoder().encodeToString(publicKey.getEncoded());
            String privateKeyString = Base64.getEncoder().encodeToString(privateKey.getEncoded());
            EnumMap<RSAKey, String> pairKeyMap = new EnumMap<RSAKey, String>(RSAKey.class);
            pairKeyMap.put(RSAKey.PUBLIC, publicKeyString);
            pairKeyMap.put(RSAKey.PRIVATE, privateKeyString);
            return pairKeyMap;
        }
        catch (NoSuchAlgorithmException e) {
            LogUtil.error(e.getMessage(), e);
            return null;
        }
    }

    public static String encrypt(String text, String publicKey) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{text, publicKey})) {
            return null;
        }
        try {
            byte[] decoded = Base64.getDecoder().decode(publicKey);
            RSAPublicKey rsaPublicKey = (RSAPublicKey)KeyFactory.getInstance(RSA).generatePublic(new X509EncodedKeySpec(decoded));
            Cipher cipher = Cipher.getInstance(RSA);
            cipher.init(1, rsaPublicKey);
            return Base64.getEncoder().encodeToString(cipher.doFinal(text.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            LogUtil.error(e.getMessage(), e);
            return null;
        }
    }

    public static String decrypt(String ciphertext, String privateKey) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{ciphertext, privateKey})) {
            return null;
        }
        try {
            byte[] bytes = Base64.getDecoder().decode(ciphertext.getBytes(StandardCharsets.UTF_8));
            byte[] decoded = Base64.getDecoder().decode(privateKey);
            RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)KeyFactory.getInstance(RSA).generatePrivate(new PKCS8EncodedKeySpec(decoded));
            Cipher cipher = Cipher.getInstance(RSA);
            cipher.init(2, rsaPrivateKey);
            return new String(cipher.doFinal(bytes));
        }
        catch (Exception e) {
            LogUtil.error(e.getMessage(), e);
            return null;
        }
    }
}

