/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.decode;

import java.nio.ByteBuffer;
import org.smartboot.http.common.utils.ByteTree;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.decode.Decoder;
import org.smartboot.http.server.impl.Request;

public abstract class AbstractDecoder
implements Decoder {
    protected static final ByteTree.EndMatcher COLON_END_MATCHER = endByte -> endByte == 58;
    protected static final ByteTree.EndMatcher CR_END_MATCHER = endByte -> endByte == 13;
    protected static final ByteTree.EndMatcher SP_END_MATCHER = endByte -> endByte == 32;
    private final HttpServerConfiguration configuration;
    private final AbstractDecoder wafDecoder;

    public AbstractDecoder(HttpServerConfiguration configuration) {
        this(configuration, null);
    }

    public AbstractDecoder(HttpServerConfiguration configuration, AbstractDecoder wafDecoder) {
        this.configuration = configuration;
        this.wafDecoder = wafDecoder;
    }

    @Override
    public final Decoder decode(ByteBuffer byteBuffer, Request request) {
        Decoder decoder = this.decode0(byteBuffer, request);
        if (this.wafDecoder == null || decoder == this) {
            return decoder;
        }
        Decoder waf = this.wafDecoder.decode0(byteBuffer, request);
        return waf == null ? decoder : waf;
    }

    protected abstract Decoder decode0(ByteBuffer var1, Request var2);

    public HttpServerConfiguration getConfiguration() {
        return this.configuration;
    }
}

