/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.decode;

import java.nio.ByteBuffer;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.exception.HttpException;
import org.smartboot.http.common.utils.ByteTree;
import org.smartboot.http.common.utils.StringUtils;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.decode.AbstractDecoder;
import org.smartboot.http.server.decode.Decoder;
import org.smartboot.http.server.decode.IgnoreHeaderDecoder;
import org.smartboot.http.server.decode.LfDecoder;
import org.smartboot.http.server.impl.HttpRequestProtocol;
import org.smartboot.http.server.impl.Request;

class HttpHeaderDecoder
extends AbstractDecoder {
    private final HeaderValueDecoder headerValueDecoder = new HeaderValueDecoder();
    private final IgnoreHeaderDecoder ignoreHeaderDecoder = new IgnoreHeaderDecoder();
    private final LfDecoder lfDecoder = new LfDecoder(this, this.getConfiguration());

    public HttpHeaderDecoder(HttpServerConfiguration configuration) {
        super(configuration);
    }

    @Override
    public Decoder decode0(ByteBuffer byteBuffer, Request request) {
        if (request.getHeaderSize() >= 0 && request.getHeaderSize() >= this.getConfiguration().getHeaderLimiter()) {
            return this.ignoreHeaderDecoder.decode(byteBuffer, request);
        }
        if (byteBuffer.remaining() < 2) {
            return this;
        }
        byteBuffer.mark();
        if (byteBuffer.get() == 13) {
            if (byteBuffer.get() != 10) {
                throw new HttpException(HttpStatus.BAD_REQUEST);
            }
            return HttpRequestProtocol.BODY_READY_DECODER;
        }
        byteBuffer.reset();
        ByteTree name = StringUtils.scanByteTree((ByteBuffer)byteBuffer, (ByteTree.EndMatcher)COLON_END_MATCHER, this.getConfiguration().getHeaderNameByteTree());
        if (name == null) {
            return this;
        }
        request.setHeaderTemp(name);
        return this.headerValueDecoder.decode(byteBuffer, request);
    }

    class HeaderValueDecoder
    implements Decoder {
        HeaderValueDecoder() {
        }

        @Override
        public Decoder decode(ByteBuffer byteBuffer, Request request) {
            ByteTree value = StringUtils.scanByteTree((ByteBuffer)byteBuffer, (ByteTree.EndMatcher)AbstractDecoder.CR_END_MATCHER, HttpHeaderDecoder.this.getConfiguration().getByteCache());
            if (value == null) {
                if (byteBuffer.remaining() == byteBuffer.capacity()) {
                    throw new HttpException(HttpStatus.REQUEST_HEADER_FIELDS_TOO_LARGE);
                }
                return this;
            }
            request.setHeadValue(value.getStringValue());
            return HttpHeaderDecoder.this.lfDecoder.decode(byteBuffer, request);
        }
    }
}

