/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.decode.multipart;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.smartboot.http.common.HeaderValue;
import org.smartboot.http.common.Multipart;
import org.smartboot.http.common.Part;
import org.smartboot.http.common.utils.ParamDecodeUtils;
import org.smartboot.http.common.utils.StringUtils;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.decode.AbstractDecoder;
import org.smartboot.http.server.decode.Decoder;
import org.smartboot.http.server.decode.multipart.PartBodyDecoder;
import org.smartboot.http.server.impl.Request;

public class PartHeaderDecoder
extends AbstractDecoder {
    private static volatile PartHeaderDecoder INSTANCE;
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String NAME = "name";
    public static final String FILENAME = "filename";

    public PartHeaderDecoder(HttpServerConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected Decoder decode0(ByteBuffer byteBuffer, Request request) {
        Multipart multipart = request.getMultipart();
        String header = this.readHeader(byteBuffer, multipart);
        if (header != null) {
            Part part = new Part();
            List<HeaderValue> parsedHeaders = this.getParsedHeaders(header);
            part.setHeaders(parsedHeaders);
            this.fillHeaders(parsedHeaders, part);
            return PartBodyDecoder.getInstance(this.getConfiguration()).decode(byteBuffer, request);
        }
        return this;
    }

    public String readHeader(ByteBuffer byteBuffer, Multipart multipart) {
        int bufferPos = multipart.getBufferPos();
        int pos = 0;
        int start = byteBuffer.position();
        while (byteBuffer.hasRemaining()) {
            byte b = byteBuffer.get();
            if (b == Multipart.HEADER_SEPARATOR[pos]) {
                if (++pos != Multipart.HEADER_SEPARATOR.length) continue;
                String headers = new String(byteBuffer.array(), start, byteBuffer.position() - start, StandardCharsets.UTF_8);
                multipart.setBufferPos(bufferPos);
                return headers;
            }
            pos = 0;
        }
        return null;
    }

    public List<HeaderValue> getParsedHeaders(String headerPart) {
        int end;
        int length = headerPart.length();
        ArrayList<HeaderValue> headers = new ArrayList<HeaderValue>();
        int start = 0;
        while (start < length && start != (end = this.getIndexEndOfLine(headerPart, start))) {
            StringBuilder header = new StringBuilder(headerPart.substring(start, end));
            start = end + 2;
            while (start < length) {
                char c;
                int notEmptyStart;
                for (notEmptyStart = start; notEmptyStart < length && ((c = headerPart.charAt(notEmptyStart)) == ' ' || c == '\t'); ++notEmptyStart) {
                }
                if (notEmptyStart == start) break;
                end = this.getIndexEndOfLine(headerPart, notEmptyStart);
                header.append(' ').append(headerPart, notEmptyStart, end);
                start = end + 2;
            }
            this.parseHeaderLine(headers, header.toString());
        }
        return headers;
    }

    private int getIndexEndOfLine(String headerPart, int end) {
        int index = end;
        while (true) {
            int offset;
            if ((offset = headerPart.indexOf(13, index)) == -1 || offset + 1 >= headerPart.length()) {
                throw new IllegalStateException("The header is incorrectly formatted");
            }
            if (headerPart.charAt(offset + 1) == '\n') {
                return offset;
            }
            index = offset + 1;
        }
    }

    private void parseHeaderLine(List<HeaderValue> headers, String headerStr) {
        int colonOffset = headerStr.indexOf(58);
        if (colonOffset == -1) {
            return;
        }
        String headerName = headerStr.substring(0, colonOffset).trim();
        String headerValue = headerStr.substring(colonOffset + 1).trim();
        HeaderValue header = new HeaderValue(headerName, headerValue);
        for (HeaderValue h : headers) {
            if (!h.getName().equals(headerName)) continue;
            h.setNextValue(header);
            return;
        }
        headers.add(header);
    }

    public void fillHeaders(List<HeaderValue> parsedHeaders, Part part) {
        for (HeaderValue headerValue : parsedHeaders) {
            if (headerValue.getName().equals(CONTENT_DISPOSITION)) {
                Map<String, String> parsed = this.parse(headerValue.getValue(), ';');
                part.setName(StringUtils.isEmpty((CharSequence)parsed.get(NAME)) ? "" : parsed.get(NAME));
                if (!parsed.containsKey(FILENAME)) continue;
                part.setIsFile(true);
                String fileName = parsed.get(FILENAME);
                fileName = fileName != null ? fileName.trim() : "";
                part.setFileName(fileName);
                continue;
            }
            if (!headerValue.getName().equals(CONTENT_TYPE)) continue;
            part.setContentType(headerValue.getValue());
        }
    }

    public Map<String, String> parse(String str, char separator) {
        if (str == null) {
            return new HashMap<String, String>();
        }
        return this.parse(str.toCharArray(), 0, str.length(), separator);
    }

    public Map<String, String> parse(char[] charArray, int offset, int length, char separator) {
        if (charArray == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        int pos = offset;
        while (pos < length) {
            String paramValue = null;
            StringBuilder paramNameBuilder = new StringBuilder();
            char[] delimiters = new char[]{'=', separator};
            boolean foundDelimiter = false;
            while (pos < length && !foundDelimiter) {
                char currentChar = charArray[pos];
                for (char delimiter : delimiters) {
                    if (currentChar != delimiter) continue;
                    foundDelimiter = true;
                    break;
                }
                if (foundDelimiter) continue;
                paramNameBuilder.append(currentChar);
                ++pos;
            }
            String paramName = paramNameBuilder.toString().trim();
            if (pos < length && charArray[pos] == '=') {
                ++pos;
                StringBuilder paramValueBuilder = new StringBuilder();
                boolean insideQuotes = false;
                while (pos < length) {
                    char currentChar;
                    if ((currentChar = charArray[pos++]) == '\"') {
                        insideQuotes = !insideQuotes;
                        continue;
                    }
                    if (!insideQuotes) {
                        for (char delimiter : delimiters) {
                            if (currentChar != delimiter) continue;
                            paramValue = paramValueBuilder.toString().trim();
                            break;
                        }
                        if (null != paramValue) break;
                    }
                    paramValueBuilder.append(currentChar);
                }
                if (paramValue == null) {
                    paramValue = paramValueBuilder.toString().trim();
                }
                try {
                    paramValue = ParamDecodeUtils.hasEncodedValue((String)paramName) ? ParamDecodeUtils.decodeRFC2231Text((String)paramValue) : ParamDecodeUtils.decodeRFC2047Text((String)paramValue);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            if (pos < length && charArray[pos] == separator) {
                ++pos;
            }
            if (StringUtils.isEmpty((CharSequence)paramName)) continue;
            paramName = ParamDecodeUtils.stripDelimiter((String)paramName);
            params.put(paramName, paramValue);
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PartHeaderDecoder getInstance(HttpServerConfiguration configuration) {
        if (INSTANCE != null) return INSTANCE;
        Class<PartHeaderDecoder> clazz = PartHeaderDecoder.class;
        synchronized (PartHeaderDecoder.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new PartHeaderDecoder(configuration);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }
}

