/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.smartboot.http.common.BufferOutputStream;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HttpMethodEnum;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.exception.HttpException;
import org.smartboot.http.common.logging.Logger;
import org.smartboot.http.common.logging.LoggerFactory;
import org.smartboot.http.common.utils.DateUtils;
import org.smartboot.http.common.utils.Mimetypes;
import org.smartboot.http.common.utils.StringUtils;
import org.smartboot.http.server.HttpRequest;
import org.smartboot.http.server.HttpResponse;
import org.smartboot.http.server.HttpServerHandler;

public class HttpStaticResourceHandler
extends HttpServerHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpStaticResourceHandler.class);
    private final File baseDir;

    public HttpStaticResourceHandler(String baseDir) {
        this.baseDir = new File(new File(baseDir).getAbsolutePath());
        if (!this.baseDir.isDirectory()) {
            throw new RuntimeException(baseDir + " is not a directory");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("dir is:{}", (Object)this.baseDir.getAbsolutePath());
        }
    }

    @Override
    public void handle(HttpRequest request, final HttpResponse response, final CompletableFuture<Object> completableFuture) throws IOException {
        File file;
        String fileName = request.getRequestURI();
        String method = request.getMethod();
        if (StringUtils.endsWith((CharSequence)fileName, (CharSequence)"/")) {
            fileName = fileName + "index.html";
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u8bf7\u6c42URL: " + fileName);
        }
        if ((file = new File(this.baseDir, URLDecoder.decode(fileName, StandardCharsets.UTF_8.name()))).isDirectory()) {
            file = new File(file, "index.html");
        }
        if (!file.isFile()) {
            this.fileNotFound(request, response, completableFuture, method);
            completableFuture.complete(null);
            return;
        }
        Date lastModifyDate = new Date(file.lastModified() / 1000L * 1000L);
        try {
            String requestModified = request.getHeader(HeaderNameEnum.IF_MODIFIED_SINCE.getName());
            if (StringUtils.isNotBlank((CharSequence)requestModified) && lastModifyDate.getTime() <= DateUtils.parseLastModified((String)requestModified).getTime()) {
                response.setHttpStatus(HttpStatus.NOT_MODIFIED);
                completableFuture.complete(null);
                return;
            }
        }
        catch (Exception e) {
            LOGGER.error("exception", (Throwable)e);
        }
        response.setHeader(HeaderNameEnum.LAST_MODIFIED.getName(), DateUtils.formatLastModified((Date)lastModifyDate));
        response.setHeader(HeaderNameEnum.CONTENT_TYPE.getName(), Mimetypes.getInstance().getMimetype(file) + "; charset=utf-8");
        if (HttpMethodEnum.HEAD.getMethod().equals(method)) {
            completableFuture.complete(null);
            return;
        }
        response.setContentLength((int)file.length());
        FileInputStream fis = new FileInputStream(file);
        completableFuture.whenComplete((o, throwable) -> {
            try {
                fis.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        final long fileSize = response.getContentLength();
        final AtomicLong readPos = new AtomicLong(0L);
        final FileChannel fileChannel = fis.getChannel();
        final ByteBuffer buffer = ByteBuffer.allocate(8192);
        int len = fileChannel.read(buffer);
        buffer.flip();
        if (len == -1) {
            completableFuture.completeExceptionally(new IOException("EOF"));
        } else if (readPos.addAndGet(len) >= fileSize) {
            response.getOutputStream().transferFrom(buffer, bufferOutputStream -> completableFuture.complete(null));
        } else {
            response.getOutputStream().transferFrom(buffer, (Consumer)new Consumer<BufferOutputStream>(){

                @Override
                public void accept(BufferOutputStream result) {
                    try {
                        buffer.compact();
                        int len = fileChannel.read(buffer);
                        buffer.flip();
                        if (len == -1) {
                            completableFuture.completeExceptionally(new IOException("EOF"));
                        } else if (readPos.addAndGet(len) >= fileSize) {
                            response.getOutputStream().transferFrom(buffer, bufferOutputStream -> completableFuture.complete(null));
                        } else {
                            response.getOutputStream().transferFrom(buffer, (Consumer)this);
                        }
                    }
                    catch (Throwable throwable) {
                        completableFuture.completeExceptionally(throwable);
                    }
                }
            });
        }
    }

    private void fileNotFound(HttpRequest request, HttpResponse response, CompletableFuture<Object> completableFuture, String method) throws IOException {
        if (request.getRequestURI().equals("/favicon.ico")) {
            try (InputStream inputStream = HttpStaticResourceHandler.class.getClassLoader().getResourceAsStream("favicon.ico");){
                int length;
                if (inputStream == null) {
                    response.setHttpStatus(HttpStatus.NOT_FOUND);
                    return;
                }
                String contentType = Mimetypes.getInstance().getMimetype("favicon.ico");
                response.setHeader(HeaderNameEnum.CONTENT_TYPE.getName(), contentType + "; charset=utf-8");
                byte[] bytes = new byte[4094];
                while ((length = inputStream.read(bytes)) != -1) {
                    response.getOutputStream().write(bytes, 0, length);
                }
            }
            return;
        }
        LOGGER.warn("file: {} not found!", (Object)request.getRequestURI());
        response.setHttpStatus(HttpStatus.NOT_FOUND);
        response.setHeader(HeaderNameEnum.CONTENT_TYPE.getName(), "text/html; charset=utf-8");
        if (!HttpMethodEnum.HEAD.getMethod().equals(method)) {
            throw new HttpException(HttpStatus.NOT_FOUND);
        }
    }
}

