/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.smartboot.http.common.BufferOutputStream;
import org.smartboot.http.common.Cookie;
import org.smartboot.http.common.HeaderValue;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.utils.Constant;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.impl.AbstractRequest;
import org.smartboot.http.server.impl.AbstractResponse;

abstract class AbstractOutputStream
extends BufferOutputStream {
    protected static String SERVER_LINE = null;
    protected final AbstractResponse response;
    protected final AbstractRequest request;
    protected final HttpServerConfiguration configuration;

    public AbstractOutputStream(AbstractRequest httpRequest, AbstractResponse response) {
        super(httpRequest.request.getAioSession());
        this.response = response;
        this.request = httpRequest;
        this.configuration = httpRequest.request.getConfiguration();
        if (SERVER_LINE == null) {
            SERVER_LINE = HeaderNameEnum.SERVER.getName() + ':' + this.configuration.serverName() + "\r\n";
        }
    }

    protected void writeHeader(BufferOutputStream.HeaderWriteSource source) throws IOException {
        if (this.committed) {
            return;
        }
        this.convertCookieToHeader();
        boolean hasHeader = this.hasHeader();
        this.writeBuffer.write(this.getHeadPart(hasHeader));
        if (hasHeader) {
            this.writeHeaders();
        }
        this.committed = true;
    }

    protected abstract byte[] getHeadPart(boolean var1);

    private void convertCookieToHeader() {
        List<Cookie> cookies = this.response.getCookies();
        if (cookies.size() > 0) {
            cookies.forEach(cookie -> this.response.addHeader(HeaderNameEnum.SET_COOKIE.getName(), cookie.toString()));
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        if (this.configuration.getWsIdleTimeout() > 0 || this.configuration.getHttpIdleTimeout() > 0) {
            this.request.request.setLatestIo(System.currentTimeMillis());
        }
    }

    protected boolean hasHeader() {
        return this.response.getHeaders().size() > 0;
    }

    private void writeHeaders() throws IOException {
        for (Map.Entry<String, HeaderValue> entry : this.response.getHeaders().entrySet()) {
            for (HeaderValue headerValue = entry.getValue(); headerValue != null; headerValue = headerValue.getNextValue()) {
                this.writeBuffer.write(this.getHeaderNameBytes(entry.getKey()));
                this.writeBuffer.write(this.getBytes(headerValue.getValue()));
                this.writeBuffer.write(Constant.CRLF_BYTES);
            }
        }
        this.writeBuffer.write(Constant.CRLF_BYTES);
    }
}

