/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.impl;

import java.nio.ByteBuffer;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.decode.Decoder;
import org.smartboot.http.server.decode.HttpMethodDecoder;
import org.smartboot.http.server.impl.Request;
import org.smartboot.socket.DecoderException;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.transport.AioSession;

public class HttpRequestProtocol
implements Protocol<Request> {
    public static final Decoder BODY_READY_DECODER = (byteBuffer, response) -> null;
    public static final Decoder BODY_CONTINUE_DECODER = (byteBuffer, response) -> null;
    private final HttpMethodDecoder httpMethodDecoder;
    private final HttpServerConfiguration configuration;

    public HttpRequestProtocol(HttpServerConfiguration configuration) {
        this.httpMethodDecoder = new HttpMethodDecoder(configuration);
        this.configuration = configuration;
    }

    public Request decode(ByteBuffer buffer, AioSession session) {
        Request request = (Request)session.getAttachment();
        Decoder decodeChain = request.getDecoder();
        if (decodeChain == null) {
            decodeChain = this.httpMethodDecoder;
        }
        if (this.configuration.getHttpIdleTimeout() > 0 || this.configuration.getWsIdleTimeout() > 0) {
            request.setLatestIo(System.currentTimeMillis());
        }
        if (decodeChain == BODY_CONTINUE_DECODER) {
            request.setDecoder(BODY_READY_DECODER);
            return null;
        }
        if (decodeChain == BODY_READY_DECODER) {
            return request;
        }
        int p = buffer.position();
        decodeChain = decodeChain.decode(buffer, request);
        request.decodeSize(buffer.position() - p);
        request.setDecoder(decodeChain);
        if (decodeChain == BODY_READY_DECODER) {
            return request;
        }
        if (buffer.remaining() == buffer.capacity()) {
            throw new DecoderException("buffer is too small when decode " + decodeChain.getClass().getName() + " ," + request);
        }
        return null;
    }
}

