/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.enhance;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.Selector;
import java.nio.channels.ShutdownChannelGroupException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Future;
import org.smartboot.socket.enhance.EnhanceAsynchronousChannelGroup;
import org.smartboot.socket.enhance.EnhanceAsynchronousServerChannel;
import org.smartboot.socket.enhance.FutureCompletionHandler;

final class EnhanceAsynchronousClientChannel
extends EnhanceAsynchronousServerChannel {
    private final EnhanceAsynchronousChannelGroup group;

    public EnhanceAsynchronousClientChannel(EnhanceAsynchronousChannelGroup group, SocketChannel channel, boolean lowMemory) throws IOException {
        super(group, channel, lowMemory);
        this.group = group;
    }

    @Override
    public <A> void connect(SocketAddress remote, A attachment, CompletionHandler<Void, ? super A> handler) {
        if (this.group.isTerminated()) {
            throw new ShutdownChannelGroupException();
        }
        if (this.channel.isConnected()) {
            throw new AlreadyConnectedException();
        }
        if (this.channel.isConnectionPending()) {
            throw new ConnectionPendingException();
        }
        this.doConnect(remote, attachment, handler);
    }

    @Override
    public Future<Void> connect(SocketAddress remote) {
        FutureCompletionHandler connectFuture = new FutureCompletionHandler();
        this.connect(remote, null, connectFuture);
        return connectFuture;
    }

    public <A> void doConnect(SocketAddress remote, A attachment, CompletionHandler<Void, ? super A> completionHandler) {
        try {
            if (completionHandler instanceof FutureCompletionHandler && ((FutureCompletionHandler)completionHandler).isDone()) {
                return;
            }
            boolean connected = this.channel.isConnectionPending();
            if (connected || this.channel.connect(remote)) {
                connected = this.channel.finishConnect();
            }
            this.channel.configureBlocking(false);
            if (connected) {
                completionHandler.completed(null, attachment);
            } else {
                this.group.commonWorker.addRegister(selector -> {
                    try {
                        this.channel.register((Selector)selector, 8, () -> this.doConnect(remote, attachment, completionHandler));
                    }
                    catch (ClosedChannelException e) {
                        completionHandler.failed(e, attachment);
                    }
                });
            }
        }
        catch (IOException e) {
            completionHandler.failed(e, attachment);
        }
    }
}

