/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.extension.plugins;

import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.smartboot.socket.channels.AsynchronousSocketChannelProxy;
import org.smartboot.socket.extension.plugins.AbstractPlugin;

public class RateLimiterPlugin<T>
extends AbstractPlugin<T> {
    private final int readRateLimiter;
    private final int writeRateLimiter;
    private final boolean enabled;
    private final int bufferTime = 10;
    private ScheduledExecutorService executorService;

    public RateLimiterPlugin(int readRateLimiter, int writeRateLimiter) {
        this.readRateLimiter = readRateLimiter;
        this.writeRateLimiter = writeRateLimiter;
        boolean bl = this.enabled = readRateLimiter > 0 && writeRateLimiter > 0;
        if (this.enabled) {
            this.executorService = Executors.newSingleThreadScheduledExecutor();
        }
    }

    @Override
    public AsynchronousSocketChannel shouldAccept(AsynchronousSocketChannel channel) {
        return this.enabled ? new RateLimiterChannel(channel, this.readRateLimiter, this.writeRateLimiter) : channel;
    }

    class RateLimiterChannel
    extends AsynchronousSocketChannelProxy {
        private final int readRateLimiter;
        private final int writeRateLimiter;
        private long latestReadTime;
        private int readSize;
        private long latestWriteTime;
        private int writeCount;

        public RateLimiterChannel(AsynchronousSocketChannel asynchronousSocketChannel, int readRateLimiter, int writeRateLimiter) {
            super(asynchronousSocketChannel);
            this.readRateLimiter = readRateLimiter;
            this.writeRateLimiter = writeRateLimiter;
        }

        @Override
        public <A> void read(final ByteBuffer dst, long timeout, TimeUnit unit, A attachment, final CompletionHandler<Integer, ? super A> handler) {
            if (dst.remaining() == 0 || this.readRateLimiter <= 0) {
                super.read(dst, timeout, unit, attachment, handler);
                return;
            }
            int availReadSize = 0;
            long remainTime = 1000L + this.latestReadTime - System.currentTimeMillis();
            if (remainTime <= 10L) {
                this.readSize = 0;
                this.latestReadTime = System.currentTimeMillis();
            }
            if ((availReadSize = Math.min(this.readRateLimiter - this.readSize, dst.remaining())) <= 0) {
                RateLimiterPlugin.this.executorService.schedule(() -> this.read(dst, timeout, unit, attachment, handler), remainTime, TimeUnit.MILLISECONDS);
                return;
            }
            final int limit = dst.limit();
            dst.limit(dst.position() + availReadSize);
            super.read(dst, timeout, unit, attachment, new CompletionHandler<Integer, A>(){

                @Override
                public void completed(Integer result, A attachment) {
                    if (result > 0) {
                        if (System.currentTimeMillis() - RateLimiterChannel.this.latestReadTime > 1000L) {
                            RateLimiterChannel.this.readSize = 0;
                            RateLimiterChannel.this.latestReadTime = System.currentTimeMillis();
                        } else {
                            RateLimiterChannel.this.readSize = RateLimiterChannel.this.readSize + result;
                        }
                    }
                    dst.limit(limit);
                    handler.completed(result, attachment);
                }

                @Override
                public void failed(Throwable exc, A attachment) {
                    handler.failed(exc, attachment);
                }
            });
        }

        @Override
        public <A> void write(final ByteBuffer src, long timeout, TimeUnit unit, A attachment, final CompletionHandler<Integer, ? super A> handler) {
            if (src.remaining() == 0 || this.writeRateLimiter <= 0) {
                super.write(src, timeout, unit, attachment, handler);
                return;
            }
            int availWriteSize = 0;
            long remainTime = 1000L + this.latestWriteTime - System.currentTimeMillis();
            if (remainTime <= 10L) {
                this.writeCount = 0;
                this.latestWriteTime = System.currentTimeMillis();
            }
            if ((availWriteSize = Math.min(this.writeRateLimiter - this.writeCount, src.remaining())) <= 0) {
                RateLimiterPlugin.this.executorService.schedule(() -> this.write(src, timeout, unit, attachment, handler), remainTime, TimeUnit.MILLISECONDS);
                return;
            }
            final int limit = src.limit();
            src.limit(src.position() + availWriteSize);
            super.write(src, timeout, unit, attachment, new CompletionHandler<Integer, A>(){

                @Override
                public void completed(Integer result, A attachment) {
                    if (result > 0) {
                        if (System.currentTimeMillis() - RateLimiterChannel.this.latestWriteTime > 1000L) {
                            RateLimiterChannel.this.writeCount = 0;
                            RateLimiterChannel.this.latestWriteTime = System.currentTimeMillis();
                        } else {
                            RateLimiterChannel.this.writeCount = RateLimiterChannel.this.writeCount + result;
                        }
                    }
                    src.limit(limit);
                    handler.completed(result, attachment);
                }

                @Override
                public void failed(Throwable exc, A attachment) {
                    handler.failed(exc, attachment);
                }
            });
        }
    }
}

