/*
 * Decompiled with CFR 0.152.
 */
package org.tron.trident.crypto.tuwenitypes;

import com.google.common.base.Preconditions;
import io.vertx.core.buffer.Buffer;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import org.tron.trident.crypto.tuwenitypes.AbstractBytes;
import org.tron.trident.crypto.tuwenitypes.ArrayWrappingBytes32;
import org.tron.trident.crypto.tuwenitypes.Bytes;
import org.tron.trident.crypto.tuwenitypes.MutableArrayWrappingBytes;
import org.tron.trident.crypto.tuwenitypes.MutableBytes;

class ArrayWrappingBytes
extends AbstractBytes {
    protected final byte[] bytes;
    protected final int offset;
    protected final int length;

    ArrayWrappingBytes(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    ArrayWrappingBytes(byte[] bytes, int offset, int length) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"Invalid negative length");
        if (bytes.length > 0) {
            Preconditions.checkElementIndex((int)offset, (int)bytes.length);
        }
        Preconditions.checkArgument((offset + length <= bytes.length ? 1 : 0) != 0, (String)"Provided length %s is too big: the value has only %s bytes from offset %s", (Object)length, (Object)(bytes.length - offset), (Object)offset);
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public byte get(int i) {
        Preconditions.checkElementIndex((int)i, (int)this.size());
        return this.bytes[this.offset + i];
    }

    @Override
    public Bytes slice(int i, int length) {
        if (i == 0 && length == this.length) {
            return this;
        }
        if (length == 0) {
            return Bytes.EMPTY;
        }
        Preconditions.checkElementIndex((int)i, (int)this.length);
        Preconditions.checkArgument((i + length <= this.length ? 1 : 0) != 0, (String)"Provided length %s is too big: the value has size %s and has only %s bytes from %s", (Object)length, (Object)this.length, (Object)(this.length - i), (Object)i);
        return length == 32 ? new ArrayWrappingBytes32(this.bytes, this.offset + i) : new ArrayWrappingBytes(this.bytes, this.offset + i, length);
    }

    @Override
    public Bytes copy() {
        if (this.offset == 0 && this.length == this.bytes.length) {
            return this;
        }
        return new ArrayWrappingBytes(this.toArray());
    }

    @Override
    public MutableBytes mutableCopy() {
        return new MutableArrayWrappingBytes(this.toArray());
    }

    @Override
    public int commonPrefixLength(Bytes other) {
        int i;
        if (!(other instanceof ArrayWrappingBytes)) {
            return super.commonPrefixLength(other);
        }
        ArrayWrappingBytes o = (ArrayWrappingBytes)other;
        for (i = 0; i < this.length && i < o.length && this.bytes[this.offset + i] == o.bytes[o.offset + i]; ++i) {
        }
        return i;
    }

    @Override
    public void update(MessageDigest digest) {
        digest.update(this.bytes, this.offset, this.length);
    }

    @Override
    public void copyTo(MutableBytes destination, int destinationOffset) {
        if (!(destination instanceof MutableArrayWrappingBytes)) {
            super.copyTo(destination, destinationOffset);
            return;
        }
        int size = this.size();
        if (size == 0) {
            return;
        }
        Preconditions.checkElementIndex((int)destinationOffset, (int)destination.size());
        Preconditions.checkArgument((destination.size() - destinationOffset >= size ? 1 : 0) != 0, (String)"Cannot copy %s bytes, destination has only %s bytes from index %s", (Object)size, (Object)(destination.size() - destinationOffset), (Object)destinationOffset);
        MutableArrayWrappingBytes d = (MutableArrayWrappingBytes)destination;
        System.arraycopy(this.bytes, this.offset, d.bytes, d.offset + destinationOffset, size);
    }

    @Override
    public void appendTo(ByteBuffer byteBuffer) {
        byteBuffer.put(this.bytes, this.offset, this.length);
    }

    @Override
    public void appendTo(Buffer buffer) {
        buffer.appendBytes(this.bytes, this.offset, this.length);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ArrayWrappingBytes)) {
            return super.equals(obj);
        }
        ArrayWrappingBytes other = (ArrayWrappingBytes)obj;
        if (this.length != other.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.bytes[this.offset + i] == other.bytes[other.offset + i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            result = 31 * result + this.bytes[this.offset + i];
        }
        return result;
    }

    @Override
    public byte[] toArray() {
        return Arrays.copyOfRange(this.bytes, this.offset, this.offset + this.length);
    }

    @Override
    public byte[] toArrayUnsafe() {
        if (this.offset == 0 && this.length == this.bytes.length) {
            return this.bytes;
        }
        return this.toArray();
    }
}

