/*
 * Decompiled with CFR 0.152.
 */
package org.twonote.rgwadmin4j.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.twonote.rgwadmin4j.RgwAdmin;
import org.twonote.rgwadmin4j.impl.ErrorUtils;
import org.twonote.rgwadmin4j.impl.RgwAdminException;
import org.twonote.rgwadmin4j.impl.S3Auth;
import org.twonote.rgwadmin4j.model.BucketInfo;
import org.twonote.rgwadmin4j.model.Cap;
import org.twonote.rgwadmin4j.model.CredentialType;
import org.twonote.rgwadmin4j.model.Quota;
import org.twonote.rgwadmin4j.model.S3Credential;
import org.twonote.rgwadmin4j.model.SubUser;
import org.twonote.rgwadmin4j.model.SwiftCredential;
import org.twonote.rgwadmin4j.model.UsageInfo;
import org.twonote.rgwadmin4j.model.User;

public class RgwAdminImpl
implements RgwAdmin {
    private static final Gson gson = new Gson();
    private static final JsonParser jsonParser = new JsonParser();
    private static final RequestBody emptyBody = RequestBody.create(null, (byte[])new byte[0]);
    private final String endpoint;
    private final OkHttpClient client;

    public RgwAdminImpl(String accessKey, String secretKey, String endpoint) {
        RgwAdminImpl.validEndpoint(endpoint);
        this.client = new OkHttpClient().newBuilder().addInterceptor((Interceptor)new S3Auth(accessKey, secretKey)).build();
        this.endpoint = endpoint;
    }

    private static void validEndpoint(String endpoint) {
        if (HttpUrl.parse((String)endpoint) == null) {
            throw new IllegalArgumentException("endpoint is invalid");
        }
    }

    private static void appendParameters(Map<String, String> parameters, HttpUrl.Builder urlBuilder) {
        if (parameters != null) {
            parameters.forEach((arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addQueryParameter(arg_0, arg_1));
        }
    }

    private static String absSubUserId(String userId, String subUserId) {
        return String.join((CharSequence)":", userId, subUserId);
    }

    private static <T> Type setModelAndGetCorrespondingList2(Class<T> type) {
        return new TypeToken<ArrayList<T>>(){}.where(new TypeParameter<T>(){}, type).getType();
    }

    @Override
    public void trimUserUsage(String userId, Map<String, String> parameters) {
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        parameters.put("uid", userId);
        this.trimUsage(parameters);
    }

    @Override
    public void trimUsage(Map<String, String> parameters) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("usage");
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        parameters.put("remove-all", "True");
        RgwAdminImpl.appendParameters(parameters, urlBuilder);
        Request request = new Request.Builder().delete().url(urlBuilder.build()).build();
        this.safeCall(request);
    }

    @Override
    public Optional<UsageInfo> getUserUsage(String userId) {
        return this.getUserUsage(userId, null);
    }

    @Override
    public Optional<UsageInfo> getUserUsage(String userId, Map<String, String> parameters) {
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        parameters.put("uid", userId);
        return this.getUsage(parameters);
    }

    @Override
    public Optional<UsageInfo> getUsage() {
        return this.getUsage(null);
    }

    @Override
    public Optional<UsageInfo> getUsage(Map<String, String> parameters) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("usage");
        RgwAdminImpl.appendParameters(parameters, urlBuilder);
        Request request = new Request.Builder().get().url(urlBuilder.build()).build();
        String resp = this.safeCall(request);
        return Optional.ofNullable(gson.fromJson(resp, UsageInfo.class));
    }

    @Override
    public List<Cap> addUserCapability(String userId, List<Cap> userCaps) {
        Request request = new Request.Builder().put(emptyBody).url(HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("user").query("caps").addQueryParameter("uid", userId).addQueryParameter("user-caps", Joiner.on((String)";").join(userCaps)).build()).build();
        String resp = this.safeCall(request);
        Type type = new TypeToken<List<Cap>>(){}.getType();
        return (List)gson.fromJson(resp, type);
    }

    @Override
    public List<Cap> removeUserCapability(String userId, List<Cap> userCaps) {
        Request request = new Request.Builder().delete().url(HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("user").query("caps").addQueryParameter("uid", userId).addQueryParameter("user-caps", Joiner.on((String)";").join(userCaps)).build()).build();
        String resp = this.safeCall(request);
        Type type = new TypeToken<List<Cap>>(){}.getType();
        return (List)gson.fromJson(resp, type);
    }

    @Override
    public List<SubUser> createSubUser(String userId, String subUserId, Map<String, String> parameters) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("user").query("subuser").addQueryParameter("uid", userId).addQueryParameter("subuser", subUserId);
        RgwAdminImpl.appendParameters(parameters, urlBuilder);
        Request request = new Request.Builder().put(emptyBody).url(urlBuilder.build()).build();
        String resp = this.safeCall(request);
        Type type = new TypeToken<List<SubUser>>(){}.getType();
        return (List)gson.fromJson(resp, type);
    }

    @Override
    public SubUser createSubUser(String userId, String subUserId, SubUser.Permission permission, CredentialType credentialType) {
        List<SubUser> subUser = this.createSubUser(userId, subUserId, (Map<String, String>)ImmutableMap.of((Object)"access", (Object)permission.toString(), (Object)"key-type", (Object)credentialType.toString(), (Object)"generate-secret", (Object)"True"));
        String absSubUserId = RgwAdminImpl.absSubUserId(userId, subUserId);
        return subUser.stream().filter(u -> absSubUserId.equals(u.getId())).findFirst().get();
    }

    public List<SubUser> modifySubUser(String userId, String subUserId, Map<String, String> parameters) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("user").query("subuser").addQueryParameter("uid", userId).addQueryParameter("subuser", subUserId);
        RgwAdminImpl.appendParameters(parameters, urlBuilder);
        Request request = new Request.Builder().post(emptyBody).url(urlBuilder.build()).build();
        String resp = this.safeCall(request);
        Type type = new TypeToken<List<SubUser>>(){}.getType();
        return (List)gson.fromJson(resp, type);
    }

    @Override
    public List<SubUser> setSubUserPermission(String userId, String subUserId, SubUser.Permission permission) {
        return this.modifySubUser(userId, subUserId, (Map<String, String>)ImmutableMap.of((Object)"access", (Object)permission.toString()));
    }

    @Override
    public List<SubUser> listSubUserInfo(String userId) {
        Optional<User> userInfo = this.getUserInfo(userId);
        if (userInfo.isPresent()) {
            return userInfo.get().getSubusers();
        }
        return new ArrayList<SubUser>();
    }

    @Override
    public Optional<SubUser> getSubUserInfo(String userId, String subUserId) {
        String absSubUserId = RgwAdminImpl.absSubUserId(userId, subUserId);
        List<SubUser> subUsers = this.listSubUserInfo(userId);
        return subUsers.stream().filter(u -> absSubUserId.equals(u.getId())).findFirst();
    }

    @Override
    public void removeSubUser(String userId, String subUserId) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("user").query("subuser").addQueryParameter("uid", userId).addQueryParameter("subuser", subUserId);
        Request request = new Request.Builder().delete().url(urlBuilder.build()).build();
        this.safeCall(request);
    }

    private <T> List<T> _createKey(String uid, Map<String, String> parameters, Class<T> returnModel) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("user").query("key").addQueryParameter("uid", uid);
        RgwAdminImpl.appendParameters(parameters, urlBuilder);
        Request request = new Request.Builder().put(emptyBody).url(urlBuilder.build()).build();
        String resp = this.safeCall(request);
        if (resp == null) {
            throw new RgwAdminException(404, "NoSuchUser");
        }
        Type type = RgwAdminImpl.setModelAndGetCorrespondingList2(returnModel);
        return (List)gson.fromJson(resp, type);
    }

    private List<S3Credential> _createKey(String uid, Map<String, String> parameters) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("user").query("key").addQueryParameter("uid", uid);
        RgwAdminImpl.appendParameters(parameters, urlBuilder);
        Request request = new Request.Builder().put(emptyBody).url(urlBuilder.build()).build();
        String resp = this.safeCall(request);
        Type type = new TypeToken<List<S3Credential>>(){}.getType();
        return (List)gson.fromJson(resp, type);
    }

    private void _removeKey(String uid, Map<String, String> parameters) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("user").query("key").addQueryParameter("uid", uid);
        RgwAdminImpl.appendParameters(parameters, urlBuilder);
        Request request = new Request.Builder().delete().url(urlBuilder.build()).build();
        String resp = this.safeCall(request);
        if (resp == null) {
            throw new RgwAdminException(404, "NoSuchUser");
        }
    }

    @Override
    public List<S3Credential> createS3Credential(String userId, String accessKey, String secretKey) {
        return this._createKey(userId, (Map<String, String>)ImmutableMap.of((Object)"access-key", (Object)accessKey, (Object)"secret-key", (Object)secretKey), S3Credential.class);
    }

    @Override
    public List<S3Credential> createS3Credential(String userId) {
        return this._createKey(userId, (Map<String, String>)ImmutableMap.of((Object)"generate-key", (Object)"True"), S3Credential.class);
    }

    @Override
    public void removeS3Credential(String userId, String accessKey) {
        this._removeKey(userId, (Map<String, String>)ImmutableMap.of((Object)"access-key", (Object)accessKey));
    }

    @Override
    public List<S3Credential> createS3CredentialForSubUser(String userId, String subUserId, String accessKey, String secretKey) {
        List<S3Credential> s3Credentials = this._createKey(userId, (Map<String, String>)ImmutableMap.of((Object)"subuser", (Object)subUserId, (Object)"access-key", (Object)accessKey, (Object)"secret-key", (Object)secretKey, (Object)"key-type", (Object)"s3"), S3Credential.class);
        return s3Credentials.stream().filter(k -> RgwAdminImpl.absSubUserId(userId, subUserId).equals(k.getUserId())).collect(Collectors.toList());
    }

    @Override
    public List<S3Credential> createS3CredentialForSubUser(String userId, String subUserId) {
        List<S3Credential> s3Credentials = this._createKey(userId, (Map<String, String>)ImmutableMap.of((Object)"subuser", (Object)subUserId, (Object)"key-type", (Object)"s3", (Object)"generate-key", (Object)"True"), S3Credential.class);
        return s3Credentials.stream().filter(k -> RgwAdminImpl.absSubUserId(userId, subUserId).equals(k.getUserId())).collect(Collectors.toList());
    }

    @Override
    public void removeS3CredentialFromSubUser(String userId, String subUserId, String accessKey) {
        this._removeKey(userId, (Map<String, String>)ImmutableMap.of((Object)"subuser", (Object)subUserId, (Object)"key-type", (Object)"s3", (Object)"access-key", (Object)accessKey));
    }

    @Override
    public SwiftCredential createSwiftCredentialForSubUser(String userId, String subUserId, String password) {
        List<SwiftCredential> swiftCredentials = this._createKey(userId, (Map<String, String>)ImmutableMap.of((Object)"subuser", (Object)subUserId, (Object)"secret-key", (Object)password, (Object)"key-type", (Object)"swift"), SwiftCredential.class);
        return (SwiftCredential)swiftCredentials.stream().filter(k -> RgwAdminImpl.absSubUserId(userId, subUserId).equals(k.getUserId())).collect(Collectors.toList()).get(0);
    }

    @Override
    public SwiftCredential createSwiftCredentialForSubUser(String userId, String subUserId) {
        List<SwiftCredential> swiftCredentials = this._createKey(userId, (Map<String, String>)ImmutableMap.of((Object)"subuser", (Object)subUserId, (Object)"key-type", (Object)"swift", (Object)"generate-key", (Object)"True"), SwiftCredential.class);
        return (SwiftCredential)swiftCredentials.stream().filter(k -> RgwAdminImpl.absSubUserId(userId, subUserId).equals(k.getUserId())).collect(Collectors.toList()).get(0);
    }

    @Override
    public void removeSwiftCredentialFromSubUser(String userId, String subUserId) {
        this._removeKey(userId, (Map<String, String>)ImmutableMap.of((Object)"subuser", (Object)subUserId, (Object)"key-type", (Object)"swift"));
    }

    @Override
    public void removeBucket(String bucketName) {
        Request request = new Request.Builder().delete().url(HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("bucket").addQueryParameter("bucket", bucketName).addQueryParameter("purge-objects", "true").build()).build();
        this.safeCall(request);
    }

    @Override
    public void linkBucket(String bucketName, String bucketId, String userId) {
        Request request = new Request.Builder().put(emptyBody).url(HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("bucket").addQueryParameter("bucket", bucketName).addQueryParameter("bucket-id", bucketId).addQueryParameter("uid", userId).build()).build();
        this.safeCall(request);
    }

    @Override
    public void unlinkBucket(String bucketName, String userId) {
        Request request = new Request.Builder().post(emptyBody).url(HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("bucket").addQueryParameter("bucket", bucketName).addQueryParameter("uid", userId).build()).build();
        this.safeCall(request);
    }

    @Override
    public Optional<String> checkBucketIndex(String bucketName, boolean isCheckObjects, boolean isFix) {
        Request request = new Request.Builder().get().url(HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("bucket").query("index").addQueryParameter("bucket", bucketName).addQueryParameter("check-objects", Boolean.toString(isCheckObjects)).addQueryParameter("fix", Boolean.toString(isFix)).build()).build();
        String resp = this.safeCall(request);
        return Optional.ofNullable(resp);
    }

    @Override
    public List<String> listBucket() {
        return this.listBucketInfo().stream().map(bkInfo -> bkInfo.getBucket()).collect(Collectors.toList());
    }

    @Override
    public List<String> listBucket(String userId) {
        return this.listBucketInfo(userId).stream().map(bkInfo -> bkInfo.getBucket()).collect(Collectors.toList());
    }

    @Override
    public List<BucketInfo> listBucketInfo() {
        return this._getBucketInfo((Map<String, String>)ImmutableMap.of((Object)"stats", (Object)"True"));
    }

    @Override
    public List<BucketInfo> listBucketInfo(String userId) {
        return this._getBucketInfo((Map<String, String>)ImmutableMap.of((Object)"uid", (Object)userId, (Object)"stats", (Object)"True"));
    }

    private List<BucketInfo> _getBucketInfo(Map<String, String> parameters) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("bucket");
        RgwAdminImpl.appendParameters(parameters, urlBuilder);
        Request request = new Request.Builder().get().url(urlBuilder.build()).build();
        String resp = this.safeCall(request);
        if (parameters.containsKey("bucket")) {
            BucketInfo response = (BucketInfo)gson.fromJson(resp, BucketInfo.class);
            ArrayList<BucketInfo> ret = new ArrayList<BucketInfo>();
            if (response != null) {
                ret.add(response);
            }
            return ret;
        }
        Type type = new TypeToken<List<BucketInfo>>(){}.getType();
        return (List)gson.fromJson(resp, type);
    }

    @Override
    public Optional<BucketInfo> getBucketInfo(String bucketName) {
        List<BucketInfo> responses = this._getBucketInfo((Map<String, String>)ImmutableMap.of((Object)"bucket", (Object)bucketName, (Object)"stats", (Object)"True"));
        if (responses.size() == 0) {
            return Optional.empty();
        }
        if (responses.size() == 1) {
            return Optional.of(responses.get(0));
        }
        throw new RuntimeException("Server should not return more than one bucket");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String safeCall(Request request) {
        try (Response response = this.client.newCall(request).execute();){
            if (response.code() == 404) {
                String string = null;
                return string;
            }
            if (!response.isSuccessful()) {
                throw ErrorUtils.parseError(response);
            }
            ResponseBody body = response.body();
            if (body != null) {
                String string = response.body().string();
                return string;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            throw new RgwAdminException(500, "IOException", e);
        }
    }

    @Override
    public User createUser(String userId) {
        return this.createUser(userId, null);
    }

    @Override
    public User createUser(String userId, Map<String, String> options) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("user").addQueryParameter("uid", userId).addQueryParameter("display-name", userId);
        RgwAdminImpl.appendParameters(options, urlBuilder);
        Request request = new Request.Builder().put(emptyBody).url(urlBuilder.build()).build();
        String resp = this.safeCall(request);
        return (User)gson.fromJson(resp, User.class);
    }

    @Override
    public Optional<User> getUserInfo(String userId) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("user").addQueryParameter("uid", userId);
        Request request = new Request.Builder().get().url(urlBuilder.build()).build();
        String resp = this.safeCall(request);
        return Optional.ofNullable(gson.fromJson(resp, User.class));
    }

    private List<String> listMetadata(MetadataType metadataType) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("metadata").addPathSegment(metadataType.toString());
        Request request = new Request.Builder().get().url(urlBuilder.build()).build();
        String resp = this.safeCall(request);
        Type type = new TypeToken<List<String>>(){}.getType();
        return (List)gson.fromJson(resp, type);
    }

    private <T> T getMetadata(MetadataType metadataType, String key, Class<T> returnType) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("metadata").addQueryParameter("key", String.join((CharSequence)":", metadataType.toString(), key));
        Request request = new Request.Builder().get().url(urlBuilder.build()).build();
        String resp = this.safeCall(request);
        JsonObject jo = (JsonObject)jsonParser.parse(resp);
        return (T)gson.fromJson(jo.get("data").toString(), returnType);
    }

    @Override
    public List<String> listUser() {
        return this.listMetadata(MetadataType.USER);
    }

    @Override
    public List<String> listSubUser(String userId) {
        return this.listSubUserInfo(userId).stream().map(s -> s.getId()).collect(Collectors.toList());
    }

    @Override
    public List<User> listUserInfo() {
        List<String> userIds = this.listMetadata(MetadataType.USER);
        return userIds.stream().map(i -> this.getMetadata(MetadataType.USER, (String)i, (Class)User.class)).collect(Collectors.toList());
    }

    @Override
    public User modifyUser(String userId, Map<String, String> parameters) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("user").addQueryParameter("uid", userId);
        parameters.forEach((arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addQueryParameter(arg_0, arg_1));
        Request request = new Request.Builder().post(emptyBody).url(urlBuilder.build()).build();
        String resp = this.safeCall(request);
        return (User)gson.fromJson(resp, User.class);
    }

    @Override
    public void suspendUser(String userId, boolean suspend) {
        this.modifyUser(userId, (Map<String, String>)ImmutableMap.of((Object)"suspended", (Object)Boolean.toString(suspend)));
    }

    @Override
    public void removeUser(String userId) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("user").addQueryParameter("uid", userId).addQueryParameter("purge-data", "true");
        Request request = new Request.Builder().delete().url(urlBuilder.build()).build();
        this.safeCall(request);
    }

    @Override
    public Optional<Quota> getUserQuota(String userId) {
        return this.getQuota(userId, "user");
    }

    @Override
    public Optional<Quota> getBucketQuota(String userId) {
        return this.getQuota(userId, "bucket");
    }

    public Optional<Quota> getQuota(String userId, String quotaType) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("user").query("quota").addQueryParameter("uid", userId).addQueryParameter("quota-type", quotaType);
        Request request = new Request.Builder().get().url(urlBuilder.build()).build();
        String resp = this.safeCall(request);
        if (resp == null) {
            throw new RgwAdminException(404, "NoSuchUser");
        }
        return Optional.ofNullable(gson.fromJson(resp, Quota.class));
    }

    @Override
    public void setIndividualBucketQuota(String userId, String bucket, long maxObjects, long maxSizeKB) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("bucket").query("quota").addQueryParameter("uid", userId).addQueryParameter("bucket", bucket);
        Request request = new Request.Builder().put(RequestBody.create(null, (String)this.buildQuotaConfig(maxObjects, maxSizeKB))).url(urlBuilder.build()).build();
        this.safeCall(request);
    }

    @Override
    public void setBucketQuota(String userId, long maxObjects, long maxSizeKB) {
        this.setUserQuota(userId, "bucket", maxObjects, maxSizeKB);
    }

    @Override
    public void setUserQuota(String userId, long maxObjects, long maxSizeKB) {
        this.setUserQuota(userId, "user", maxObjects, maxSizeKB);
    }

    public void setUserQuota(String userId, String quotaType, long maxObjects, long maxSizeKB) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("user").query("quota").addQueryParameter("uid", userId).addQueryParameter("quota-type", quotaType);
        Request request = new Request.Builder().put(RequestBody.create(null, (String)this.buildQuotaConfig(maxObjects, maxSizeKB))).url(urlBuilder.build()).build();
        this.safeCall(request);
    }

    private String buildQuotaConfig(long maxObjects, long maxSizeKB) {
        return gson.toJson((Object)ImmutableMap.of((Object)"max_objects", (Object)String.valueOf(maxObjects), (Object)"max_size_kb", (Object)String.valueOf(maxSizeKB), (Object)"enabled", (Object)"true"));
    }

    @Override
    public void removeObject(String bucketName, String objectKey) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("bucket").query("object").addQueryParameter("bucket", bucketName).addQueryParameter("object", objectKey);
        Request request = new Request.Builder().delete().url(urlBuilder.build()).build();
        this.safeCall(request);
    }

    @Override
    public Optional<String> getObjectPolicy(String bucketName, String objectKey) {
        return this._getPolicy(bucketName, objectKey);
    }

    @Override
    public Optional<String> getBucketPolicy(String bucketName) {
        return this._getPolicy(bucketName, null);
    }

    private Optional<String> _getPolicy(String bucketName, String objectKey) {
        if (Strings.isNullOrEmpty((String)bucketName)) {
            throw new IllegalArgumentException("no bucketName");
        }
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.endpoint).newBuilder().addPathSegment("bucket").query("policy").addQueryParameter("bucket", bucketName);
        if (!Strings.isNullOrEmpty((String)objectKey)) {
            urlBuilder.addQueryParameter("object", objectKey);
        }
        Request request = new Request.Builder().get().url(urlBuilder.build()).build();
        return Optional.ofNullable(this.safeCall(request));
    }

    static enum MetadataType {
        USER("user"),
        BUCKET("bucket"),
        BUCKET_INSTANCE("bucket.instance");

        String s;

        private MetadataType(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }
    }
}

