/*
 * Decompiled with CFR 0.152.
 */
package org.twonote.rgwadmin4j.impl;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Map;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

class S3Auth
implements Interceptor {
    private final String accessKey;
    private final String secretKey;
    private final Set<String> subResources = ImmutableSet.of((Object)"acl", (Object)"lifecycle", (Object)"location", (Object)"logging", (Object)"notification", (Object)"partNumber", (Object[])new String[]{"policy", "requestPayment", "torrent", "uploadId", "uploads", "versionId", "versioning", "versions", "website"});
    Set<String> queryStrings = ImmutableSet.of((Object)"response-content-type", (Object)"response-content-language", (Object)"response-expires", (Object)"response-cache-control", (Object)"response-content-disposition", (Object)"response-content-encoding", (Object[])new String[0]);

    public S3Auth(String accessKey, String secretKey) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    private static String encodeBase64(byte[] data) {
        String base64 = Base64.getEncoder().encodeToString(data);
        if (base64.endsWith("\r\n")) {
            base64 = base64.substring(0, base64.length() - 2);
        }
        if (base64.endsWith("\n")) {
            base64 = base64.substring(0, base64.length() - 1);
        }
        return base64;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String httpVerb = request.method();
        String date = DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now(ZoneId.of("GMT")));
        String resource = request.url().encodedPath();
        try {
            String subresource = request.url().queryParameterName(0);
            if (this.subResources.contains(subresource)) {
                resource = resource + "?" + subresource;
            }
        }
        catch (Exception subresource) {
            // empty catch block
        }
        String sign = this.sign(httpVerb, date, resource);
        request = request.newBuilder().header("Authorization", sign).header("Date", date).build();
        return chain.proceed(request);
    }

    private String sign(String httpVerb, String date, String resource) {
        return this.sign(httpVerb, "", "", date, resource, null);
    }

    private String sign(String httpVerb, String contentMD5, String contentType, String date, String resource, Map<String, String> metas) {
        StringBuilder stringToSign = new StringBuilder(httpVerb + "\n" + CharMatcher.whitespace().trimFrom((CharSequence)contentMD5) + "\n" + CharMatcher.whitespace().trimFrom((CharSequence)contentType) + "\n" + date + "\n");
        if (metas != null) {
            for (Map.Entry<String, String> entity : metas.entrySet()) {
                stringToSign.append(CharMatcher.whitespace().trimFrom((CharSequence)entity.getKey())).append(":").append(CharMatcher.whitespace().trimFrom((CharSequence)entity.getValue())).append("\n");
            }
        }
        stringToSign.append(resource);
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            byte[] keyBytes = this.secretKey.getBytes("UTF8");
            SecretKeySpec signingKey = new SecretKeySpec(keyBytes, "HmacSHA1");
            mac.init(signingKey);
            byte[] signBytes = mac.doFinal(stringToSign.toString().getBytes("UTF8"));
            String signature = S3Auth.encodeBase64(signBytes);
            return "AWS " + this.accessKey + ":" + signature;
        }
        catch (Exception e) {
            throw new RuntimeException("MAC CALC FAILED.");
        }
    }
}

