/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger.properties;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Objects;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.schema.Example;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.VendorExtension;

public class ParameterProperties {
    private String name;
    private String description;
    private String defaultValue;
    private boolean required;
    private boolean allowMultiple;
    private AllowableValues allowableValues;
    private String paramType = "header";
    private String paramAccess;
    private String modelRef = "string";
    private boolean hidden;
    private String pattern;
    private List<VendorExtension> vendorExtensions = Lists.newArrayList();
    private String collectionFormat = null;
    private Boolean allowEmptyValue;
    private int order = Integer.MAX_VALUE;
    private Object scalarExample;
    private Multimap<String, Example> examples = LinkedListMultimap.create();

    public ParameterProperties setName(String name) {
        this.name = (String)BuilderDefaults.defaultIfAbsent((Object)name, (Object)this.name);
        return this;
    }

    public ParameterProperties setDescription(String description) {
        this.description = (String)BuilderDefaults.defaultIfAbsent((Object)description, (Object)this.description);
        return this;
    }

    public ParameterProperties setDefaultValue(String defaultValue) {
        this.defaultValue = (String)BuilderDefaults.defaultIfAbsent((Object)defaultValue, (Object)this.defaultValue);
        return this;
    }

    public ParameterProperties setRequired(boolean required) {
        this.required = required;
        return this;
    }

    public ParameterProperties setAllowMultiple(boolean allowMultiple) {
        this.allowMultiple = allowMultiple;
        return this;
    }

    public ParameterProperties setAllowableValues(AllowableValues allowableValues) {
        this.allowableValues = BuilderDefaults.emptyToNull((AllowableValues)allowableValues, (AllowableValues)this.allowableValues);
        return this;
    }

    public ParameterProperties setParameterAccess(String paramAccess) {
        this.paramAccess = (String)BuilderDefaults.defaultIfAbsent((Object)paramAccess, (Object)this.paramAccess);
        return this;
    }

    public ParameterProperties setModelRef(String modelRef) {
        this.modelRef = (String)BuilderDefaults.defaultIfAbsent((Object)modelRef, (Object)this.modelRef);
        return this;
    }

    public ParameterProperties setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public ParameterProperties setCollectionFormat(String collectionFormat) {
        this.collectionFormat = (String)BuilderDefaults.defaultIfAbsent((Object)collectionFormat, (Object)this.collectionFormat);
        return this;
    }

    public ParameterProperties setAllowEmptyValue(Boolean allowEmptyValue) {
        this.allowEmptyValue = (Boolean)BuilderDefaults.defaultIfAbsent((Object)allowEmptyValue, (Object)this.allowEmptyValue);
        return this;
    }

    public ParameterProperties setOrder(int order) {
        this.order = order;
        return this;
    }

    public ParameterProperties setPattern(String pattern) {
        this.pattern = (String)BuilderDefaults.defaultIfAbsent((Object)pattern, (Object)this.pattern);
        return this;
    }

    public ParameterProperties setScalarExample(Object scalarExample) {
        this.scalarExample = BuilderDefaults.defaultIfAbsent((Object)scalarExample, (Object)this.scalarExample);
        return this;
    }

    public ParameterProperties setComplexExamples(Multimap<String, Example> examples) {
        this.examples.putAll(examples);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isAllowMultiple() {
        return this.allowMultiple;
    }

    public AllowableValues getAllowableValues() {
        return this.allowableValues;
    }

    public String getParamType() {
        return this.paramType;
    }

    public void setParamType(String paramType) {
        this.paramType = paramType;
    }

    public String getParamAccess() {
        return this.paramAccess;
    }

    public void setParamAccess(String paramAccess) {
        this.paramAccess = paramAccess;
    }

    public String getModelRef() {
        return this.modelRef;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getCollectionFormat() {
        return this.collectionFormat;
    }

    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public int getOrder() {
        return this.order;
    }

    public Object getScalarExample() {
        return this.scalarExample;
    }

    public Multimap<String, Example> getExamples() {
        return this.examples;
    }

    public void setExamples(Multimap<String, Example> examples) {
        this.examples = examples;
    }

    public Parameter build() {
        if (!ImmutableList.of((Object)"query", (Object)"formData").contains((Object)this.paramType)) {
            this.allowEmptyValue = null;
        }
        Objects.requireNonNull(this.name, "globalParameter cannot be null");
        Objects.requireNonNull(this.paramType, "globalParameter type cannot be null(query,header,cookie,body)");
        return new Parameter(this.name, this.description, this.defaultValue, this.required, this.allowMultiple, this.allowEmptyValue, (ModelReference)new ModelRef(this.modelRef), Optional.absent(), this.allowableValues, this.paramType, this.paramAccess, this.hidden, this.pattern, this.collectionFormat, this.order, this.scalarExample, this.examples, this.vendorExtensions);
    }

    public String toString() {
        return "ParameterProperties(name=" + this.getName() + ", description=" + this.getDescription() + ", defaultValue=" + this.getDefaultValue() + ", required=" + this.isRequired() + ", allowMultiple=" + this.isAllowMultiple() + ", allowableValues=" + this.getAllowableValues() + ", paramType=" + this.getParamType() + ", paramAccess=" + this.getParamAccess() + ", modelRef=" + this.getModelRef() + ", hidden=" + this.isHidden() + ", pattern=" + this.getPattern() + ", vendorExtensions=" + this.vendorExtensions + ", collectionFormat=" + this.getCollectionFormat() + ", allowEmptyValue=" + this.getAllowEmptyValue() + ", order=" + this.getOrder() + ", scalarExample=" + this.getScalarExample() + ", examples=" + this.getExamples() + ")";
    }
}

