/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger.properties;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import io.github.swagger.properties.SecurityReferenceProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpMethod;
import springfox.documentation.spi.service.contexts.SecurityContext;

public class SecurityContextProperties {
    private List<SecurityReferenceProperties> securityReferences;
    private List<String> pathSelectors = new ArrayList<String>();
    private List<HttpMethod> methodSelectors = Lists.newArrayList((Object[])new HttpMethod[]{HttpMethod.PUT, HttpMethod.GET, HttpMethod.POST, HttpMethod.DELETE});

    public SecurityContext toSecurityContext() {
        Predicate httpMethodPredicate = this.methodSelectors.stream().map(Predicates::equalTo).reduce(Predicates::or).orElse(Predicates.alwaysTrue());
        Predicate str = Predicates.or((Predicate[])new Predicate[0]);
        Predicate selectorPredicate = this.pathSelectors.isEmpty() ? Predicates.alwaysTrue() : this.pathSelectors.stream().map(e -> Predicates.or((Predicate)str, (Predicate)Predicates.containsPattern((String)e))).reduce(Predicates::or).orElse(Predicates.alwaysTrue());
        List referenceList = this.securityReferences.stream().map(SecurityReferenceProperties::toSecurityReference).collect(Collectors.toList());
        return new SecurityContext(referenceList, selectorPredicate, httpMethodPredicate);
    }

    public void setSecurityReferences(List<SecurityReferenceProperties> securityReferences) {
        this.securityReferences = securityReferences;
    }

    public void setPathSelectors(List<String> pathSelectors) {
        this.pathSelectors = pathSelectors;
    }

    public void setMethodSelectors(List<HttpMethod> methodSelectors) {
        this.methodSelectors = methodSelectors;
    }

    public String toString() {
        return "SecurityContextProperties(securityReferences=" + this.securityReferences + ", pathSelectors=" + this.pathSelectors + ", methodSelectors=" + this.methodSelectors + ")";
    }
}

