/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger.properties.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.GrantType;
import springfox.documentation.service.OAuth;

public class OAuthProperties {
    private String name;
    private Map<String, String> scopes;
    private List<String> grantTypes;

    public OAuth toOAuth() {
        ArrayList securityScopes = new ArrayList(this.scopes.size());
        this.scopes.forEach((scope, desc) -> securityScopes.add(new AuthorizationScope(scope, desc)));
        return new OAuth(this.name, securityScopes, this.grantTypes.stream().map(GrantType::new).collect(Collectors.toList()));
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setScopes(Map<String, String> scopes) {
        this.scopes = scopes;
    }

    public void setGrantTypes(List<String> grantTypes) {
        this.grantTypes = grantTypes;
    }

    public String toString() {
        return "OAuthProperties(name=" + this.name + ", scopes=" + this.scopes + ", grantTypes=" + this.grantTypes + ")";
    }
}

