/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.http.executor;

import io.github.wycst.wast.clients.http.definition.HttpClientConfig;
import io.github.wycst.wast.clients.http.definition.HttpClientException;
import io.github.wycst.wast.clients.http.definition.HttpClientParameter;
import io.github.wycst.wast.clients.http.definition.HttpClientRequest;
import io.github.wycst.wast.clients.http.definition.HttpClientResponse;
import io.github.wycst.wast.clients.http.exception.ConnectException;
import io.github.wycst.wast.clients.http.provider.DefaultServiceProvider;
import io.github.wycst.wast.clients.http.provider.RequestServiceInstance;
import io.github.wycst.wast.clients.http.provider.ServiceInstance;
import io.github.wycst.wast.clients.http.provider.ServiceProvider;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;

public abstract class HttpClientExecutor {
    private ServiceProvider serviceProvider = new DefaultServiceProvider();
    private boolean enableLoadBalance = false;
    private boolean keepAliveOnTimeout;

    protected abstract HttpClientResponse doExecuteRequest(HttpClientRequest var1) throws Throwable;

    public abstract byte[] fastGetBody(String var1, Map<String, String> var2);

    public abstract InputStream fastGetInputStream(String var1, Map<String, String> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClientResponse executeRequest(HttpClientRequest httpRequest) {
        this.checkIfEmptyRequest(httpRequest);
        HttpClientResponse clientResponse = null;
        try {
            clientResponse = this.doExecuteRequest(httpRequest);
        }
        catch (Throwable e) {
            this.handleExecuteRequestThrowable(e, httpRequest);
        }
        return clientResponse;
    }

    protected RequestServiceInstance getRequestServiceInstance(HttpClientRequest httpRequest) throws MalformedURLException {
        RequestServiceInstance requestServiceInstance = new RequestServiceInstance();
        if (this.enableLoadBalance) {
            this.checkServiceProvider();
            ServiceInstance serviceInstance = this.serviceProvider.getServiceInstance(httpRequest);
            if (serviceInstance == null) {
                requestServiceInstance.setUrl(httpRequest.getURL());
            } else {
                URL url = httpRequest.getURL();
                String baseUrl = serviceInstance.getBaseUrl();
                String newUrl = url.getProtocol() + "://" + baseUrl + url.getFile();
                requestServiceInstance.setServiceInstance(serviceInstance);
                requestServiceInstance.setUrl(new URL(newUrl));
            }
        } else {
            requestServiceInstance.setUrl(httpRequest.getURL());
        }
        return requestServiceInstance;
    }

    private void checkServiceProvider() throws MalformedURLException {
        if (this.serviceProvider == null) {
            throw new HttpClientException("No service provider was specified when load balancing scheduling was enabled");
        }
    }

    private void checkIfEmptyRequest(HttpClientRequest httpRequest) {
        if (httpRequest == null) {
            throw new HttpClientException("Request is null");
        }
        if (httpRequest.getURL() == null) {
            throw new HttpClientException("The URL of the request is not defined");
        }
    }

    protected URL parseQueryUrl(URL instanceUrl, String method, HttpClientConfig clientConfig) throws UnsupportedEncodingException, MalformedURLException {
        if (instanceUrl == null) {
            return null;
        }
        if ("GET".equals(method) || "DELETE".equals(method)) {
            List<HttpClientParameter> clientParameters = clientConfig.getParameterList();
            if (clientParameters == null || clientParameters.size() == 0) {
                return instanceUrl;
            }
            String url = instanceUrl.toString();
            int deleteIndex = url.indexOf("#");
            if (deleteIndex > -1) {
                url = new String(url.substring(0, deleteIndex));
            }
            StringBuilder queryParamBuffer = new StringBuilder();
            if (url.indexOf("?") == -1) {
                queryParamBuffer.append("?");
            } else if (!url.endsWith("?")) {
                queryParamBuffer.append("&");
            }
            int length = clientParameters.size();
            int i = 0;
            for (HttpClientParameter clientParameter : clientParameters) {
                ++i;
                if (clientParameter.isFileUpload()) continue;
                queryParamBuffer.append(URLEncoder.encode(clientParameter.getName(), "UTF-8")).append('=').append(URLEncoder.encode(clientParameter.getValue(), "UTF-8"));
                if (i >= length) continue;
                queryParamBuffer.append('&');
            }
            url = url + queryParamBuffer.toString();
            return new URL(url);
        }
        return instanceUrl;
    }

    public void setEnableLoadBalance(boolean enableLoadBalance) {
        this.enableLoadBalance = enableLoadBalance;
    }

    public void setServiceProvider(ServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    public boolean isEnableLoadBalance() {
        return this.enableLoadBalance;
    }

    public boolean isKeepAliveOnTimeout() {
        return this.keepAliveOnTimeout;
    }

    public void setKeepAliveOnTimeout(boolean keepAliveOnTimeout) {
        this.keepAliveOnTimeout = keepAliveOnTimeout;
    }

    private void handleExecuteRequestThrowable(Throwable e, HttpClientRequest httpRequest) {
        if (e instanceof UnknownHostException) {
            throw new io.github.wycst.wast.clients.http.exception.UnknownHostException(e.getMessage(), e);
        }
        if (e instanceof java.net.ConnectException) {
            throw new ConnectException(e.getMessage(), e);
        }
        if (e instanceof SocketTimeoutException) {
            throw new io.github.wycst.wast.clients.http.exception.SocketTimeoutException(e.getMessage(), e);
        }
        throw new HttpClientException(e.getMessage(), e);
    }
}

