/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.http.impl;

import io.github.wycst.wast.clients.http.definition.HttpClientResponse;
import io.github.wycst.wast.common.utils.IOUtils;
import java.io.IOException;
import java.io.InputStream;

abstract class AbstractHttpClientResponse
implements HttpClientResponse {
    private final int status;
    private final String reasonPhrase;
    private final int contentLength;
    private byte[] content;

    public AbstractHttpClientResponse(int code, String reasonPhrase, InputStream is, int contentLength) {
        this.status = code;
        this.reasonPhrase = reasonPhrase;
        this.contentLength = contentLength;
        this.writeStreamToContent(is);
    }

    public AbstractHttpClientResponse(int code, String reasonPhrase, byte[] content) {
        this.status = code;
        this.reasonPhrase = reasonPhrase;
        this.content = content;
        this.contentLength = content == null ? -1 : content.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStreamToContent(InputStream is) {
        if (is != null) {
            boolean isClosed = false;
            try {
                if (this.contentLength > 0) {
                    int count;
                    byte[] buf = new byte[this.contentLength];
                    int offset = 0;
                    int len = buf.length;
                    while ((count = is.read(buf, offset, len)) != -1) {
                        offset += count;
                        if (count == len) break;
                        len -= count;
                    }
                    if (offset != this.contentLength) {
                        // empty if block
                    }
                    this.content = buf;
                } else {
                    this.content = IOUtils.readBytes(is);
                    isClosed = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (!isClosed) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public int status() {
        return this.status;
    }

    @Override
    public String reasonPhrase() {
        return this.reasonPhrase;
    }

    @Override
    public byte[] content() {
        return this.content;
    }

    @Override
    public int length() {
        return this.content == null ? -1 : this.content.length;
    }
}

