/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.http.provider;

import io.github.wycst.wast.clients.http.provider.ServiceInstance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ServerZone {
    private String serverName;
    private List<ServiceInstance> serviceInstances;
    private int current;
    private boolean staticServer;

    public ServerZone(String serverName, String[] urls) {
        this(serverName, urls, false);
    }

    public ServerZone(String serverName, String[] urls, boolean staticServer) {
        this(serverName, Arrays.asList(urls), staticServer);
    }

    public ServerZone(String serverName, List<String> urls) {
        this(serverName, urls, false);
    }

    public ServerZone(String serverName, List<String> urls, boolean staticServer) {
        this.serverName = serverName;
        this.staticServer = staticServer;
        this.serviceInstances = new ArrayList<ServiceInstance>();
        for (String baseUrl : urls) {
            ServiceInstance serviceInstance = new ServiceInstance();
            serviceInstance.setServiceName(serverName);
            serviceInstance.setBaseUrl(baseUrl);
            serviceInstance.setAlive(true);
            this.serviceInstances.add(serviceInstance);
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public List<ServiceInstance> getServiceInstances() {
        return this.serviceInstances;
    }

    public void setServiceInstances(List<ServiceInstance> serviceInstances) {
        this.serviceInstances = serviceInstances;
    }

    public synchronized int nextIndex(int capacity) {
        ++this.current;
        if (this.current >= capacity) {
            this.current = 0;
        }
        return this.current;
    }

    public boolean isStaticServer() {
        return this.staticServer;
    }

    public void setStaticServer(boolean staticServer) {
        this.staticServer = staticServer;
    }
}

