/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.beans;

import io.github.wycst.wast.common.utils.CollectionUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ArrayQueueMap<K, V> {
    final Object[] keys;
    final Map<K, V> map;
    final int size;
    int count;

    public ArrayQueueMap(int size) {
        this.keys = new Object[size];
        this.map = new ConcurrentHashMap(size);
        this.size = size;
    }

    public V get(K k) {
        return this.map.get(k);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K k, V v) {
        V oldValue = this.map.get(k);
        if (oldValue != null) {
            this.map.put(k, v);
        } else {
            ArrayQueueMap arrayQueueMap = this;
            synchronized (arrayQueueMap) {
                int n;
                if (this.count < this.size) {
                    int n2 = this.count;
                    n = n2;
                    this.count = n2 + 1;
                } else {
                    n = this.count = 0;
                }
                int index = n;
                Object oldKey = this.keys[index];
                if (oldKey != null) {
                    this.map.remove(oldKey);
                }
                this.keys[index] = k;
                this.map.put(k, v);
            }
        }
    }

    public V remove(K k) {
        return this.map.remove(k);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayQueueMap arrayQueueMap = this;
        synchronized (arrayQueueMap) {
            this.count = 0;
            this.map.clear();
            CollectionUtils.clear(this.keys);
        }
    }
}

