/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.beans.geo;

import io.github.wycst.wast.common.beans.geo.Geometry;
import io.github.wycst.wast.common.beans.geo.GeometryContext;
import io.github.wycst.wast.common.beans.geo.GeometryType;
import io.github.wycst.wast.common.beans.geo.Point;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractPoints
extends Geometry {
    protected List<Point> points = new ArrayList<Point>();

    public AbstractPoints(GeometryType geometryType) {
        super(geometryType);
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public void setPoints(List<Point> points) {
        this.points = points;
    }

    public void add(Point point) {
        this.points.add(point);
    }

    public void addAll(Point ... pointList) {
        for (Point point : pointList) {
            this.points.add(point);
        }
    }

    public void addAll(List<Point> pointList) {
        this.points.addAll(pointList);
    }

    public Point removeAt(int index) {
        return this.points.remove(index);
    }

    public boolean remove(Point point) {
        return this.points.remove(point);
    }

    public void clear() {
        this.points.clear();
    }

    @Override
    void appendBody(StringBuilder builder) {
        builder.append("(");
        int deleteDotIndex = -1;
        for (Point point : this.points) {
            builder.append(point.x).append(" ").append(point.y);
            builder.append(",");
            deleteDotIndex = builder.length() - 1;
        }
        if (deleteDotIndex > -1) {
            builder.deleteCharAt(deleteDotIndex);
        }
        builder.append(")");
    }

    @Override
    final void readBody(char[] chars, GeometryContext geometryContext) {
        this.setPoints(AbstractPoints.readPoints(chars, geometryContext));
    }
}

