/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.compiler;

import io.github.wycst.wast.common.compiler.MemoryJavaFileObject;

public class MemoryClassLoader
extends ClassLoader {
    private MemoryJavaFileObject javaFileObject;

    public MemoryClassLoader(MemoryJavaFileObject javaFileObject) {
        this(javaFileObject, ClassLoader.getSystemClassLoader());
    }

    public MemoryClassLoader(MemoryJavaFileObject javaFileObject, ClassLoader parentLoader) {
        super(parentLoader);
        this.javaFileObject = javaFileObject;
    }

    public MemoryClassLoader() {
    }

    public MemoryClassLoader(ClassLoader parentLoader) {
        super(parentLoader);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.javaFileObject == null) {
            return null;
        }
        byte[] codeBytes = this.javaFileObject.getBytes();
        return this.defineClass(name, codeBytes, 0, codeBytes.length);
    }

    public Class<?> loadClass(String name, byte[] codeBytes) {
        return this.defineClass(name, codeBytes, 0, codeBytes.length);
    }
}

