/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.compiler;

import io.github.wycst.wast.common.compiler.JavaSourceObject;
import io.github.wycst.wast.common.compiler.MemoryJavaFileObject;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class MemoryJavaFileManager
extends ForwardingJavaFileManager {
    private Map<String, MemoryJavaFileObject> fileObjectMap = new HashMap<String, MemoryJavaFileObject>();
    private MemoryJavaFileObject lastMemoryJavaFileObject;

    public MemoryJavaFileManager(JavaFileManager fileManager) {
        super(fileManager);
    }

    public MemoryJavaFileManager(JavaFileManager fileManager, JavaSourceObject ... javaSourceObjects) {
        super(fileManager);
        for (JavaSourceObject javaSourceObject : javaSourceObjects) {
            this.fileObjectMap.put(javaSourceObject.canonicalName, new MemoryJavaFileObject(javaSourceObject.canonicalName, JavaFileObject.Kind.SOURCE));
        }
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        MemoryJavaFileObject memoryJavaFileObject = this.fileObjectMap.get(className);
        if (memoryJavaFileObject == null) {
            memoryJavaFileObject = new MemoryJavaFileObject(className, JavaFileObject.Kind.SOURCE);
            this.fileObjectMap.put(className, memoryJavaFileObject);
        }
        this.lastMemoryJavaFileObject = memoryJavaFileObject;
        return this.lastMemoryJavaFileObject;
    }

    public JavaFileObject createJavaFileObject(String name, String code) {
        return new MemoryInputJavaFileObject(name, code);
    }

    public MemoryJavaFileObject getLastMemoryJavaFileObject() {
        return this.lastMemoryJavaFileObject;
    }

    public Map<String, MemoryJavaFileObject> getFileObjectMap() {
        return this.fileObjectMap;
    }

    class MemoryInputJavaFileObject
    extends SimpleJavaFileObject {
        final String code;

        MemoryInputJavaFileObject(String name, String code) {
            super(URI.create("string:///" + name), JavaFileObject.Kind.SOURCE);
            this.code = code;
        }

        @Override
        public String getCharContent(boolean ignoreEncodingErrors) {
            return this.code;
        }
    }
}

