/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression;

import io.github.wycst.wast.common.expression.ElVariableInvoker;
import io.github.wycst.wast.common.expression.ExprFunction;
import io.github.wycst.wast.common.expression.ExprParser;
import io.github.wycst.wast.common.expression.ExpressionException;
import io.github.wycst.wast.common.expression.functions.BuiltInFunction;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.BeanUtils;
import io.github.wycst.wast.common.utils.CollectionUtils;
import io.github.wycst.wast.common.utils.ObjectUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.MathContext;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class EvaluateEnvironment {
    private Map<String, ExprFunction> functionMap = new HashMap<String, ExprFunction>();
    Object context;
    private Map<String, Object> variables = new HashMap<String, Object>();
    private Map<String, ExprParser> computedEls = new LinkedHashMap<String, ExprParser>();
    boolean computable;
    boolean mapContext;
    boolean allowVariableNull;
    private boolean autoParseStringAsDouble;
    MathContext mathContext = MathContext.DECIMAL128;
    private Map<String, Method> staticMethods = new HashMap<String, Method>();
    private Set<Class> staticClassSet = new HashSet<Class>();
    private static final Map<String, Method> BUILT_IN_STATIC_METHODS = new HashMap<String, Method>();
    private static final Set<Class> BLACKLIST_LIST = CollectionUtils.setOf(System.class, Runtime.class, URLClassLoader.class);
    static final EvaluateEnvironment DEFAULT;
    private Map<String, ExprFunction> tempFunctionMap = new HashMap<String, ExprFunction>();

    public void setAutoParseStringAsDouble(boolean autoParseStringAsDouble) {
        this.autoParseStringAsDouble = autoParseStringAsDouble;
    }

    public final boolean isAutoParseStringAsDouble() {
        return this.autoParseStringAsDouble;
    }

    public void setAllowVariableNull(boolean allowVariableNull) {
        this.allowVariableNull = allowVariableNull;
    }

    public EvaluateEnvironment allowVariableNull(boolean allowVariableNull) {
        this.allowVariableNull = allowVariableNull;
        return this;
    }

    public final boolean isAllowVariableNull() {
        return this.allowVariableNull;
    }

    public void setMathContext(MathContext mathContext) {
        mathContext.toString();
        this.mathContext = mathContext;
    }

    public EvaluateEnvironment mathContext(MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    private static void registerStaticMethods(boolean global, Class<?> functionClass, Map<String, Method> staticMethods) {
        Method[] methods;
        String className = functionClass.getSimpleName();
        for (Method method : methods = functionClass.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers())) continue;
            UnsafeHelper.setAccessible(method);
            String methodName = method.getName();
            staticMethods.put(global ? methodName : className + "." + methodName, method);
        }
    }

    protected EvaluateEnvironment() {
        this.staticMethods.putAll(BUILT_IN_STATIC_METHODS);
    }

    public Object getContext() {
        return this.context;
    }

    boolean isMapContext() {
        return this.mapContext;
    }

    public static EvaluateEnvironment create() {
        EvaluateEnvironment environment = new EvaluateEnvironment();
        environment.context = environment.variables;
        environment.mapContext = true;
        return environment;
    }

    public static EvaluateEnvironment create(Object context) {
        if (context instanceof EvaluateEnvironment) {
            return (EvaluateEnvironment)context;
        }
        EvaluateEnvironment environment = new EvaluateEnvironment();
        environment.context = context;
        environment.mapContext = context instanceof Map;
        return environment;
    }

    public EvaluateEnvironment registerFunction(String name, ExprFunction function) {
        this.functionMap.put(name.trim(), function);
        return this;
    }

    public EvaluateEnvironment unregisterFunction(String name) {
        this.functionMap.remove(name.trim());
        return this;
    }

    public EvaluateEnvironment registerStaticMethods(Class<?> ... classList) {
        return this.registerStaticMethods(false, classList);
    }

    public EvaluateEnvironment registerStaticMethods(boolean global, Class<?> ... classList) {
        for (Class<?> clazz : classList) {
            if (BLACKLIST_LIST.contains(clazz) || !this.staticClassSet.add(clazz)) continue;
            EvaluateEnvironment.registerStaticMethods(global, clazz, this.staticMethods);
        }
        return this;
    }

    protected Map<String, ExprFunction> getFunctionMap() {
        return this.functionMap;
    }

    protected ExprFunction getFunction(String functionName) {
        if (this.functionMap.containsKey(functionName = functionName.trim())) {
            return this.functionMap.get(functionName);
        }
        if (this.tempFunctionMap.containsKey(functionName)) {
            return this.tempFunctionMap.get(functionName);
        }
        if (this.staticMethods.containsKey(functionName)) {
            MethodFunction exprFunction = new MethodFunction(functionName, this.staticMethods.get(functionName));
            this.tempFunctionMap.put(functionName, exprFunction);
            return exprFunction;
        }
        return null;
    }

    public EvaluateEnvironment bindings(Map<String, Object> vars) {
        this.variables.putAll(vars);
        return this;
    }

    public EvaluateEnvironment binding(String key, Object value) {
        this.variables.put(key, value);
        return this;
    }

    public EvaluateEnvironment removeBinding(String key) {
        this.variables.remove(key);
        this.computedEls.remove(key);
        this.computable = !this.computedEls.isEmpty();
        return this;
    }

    public EvaluateEnvironment bindingComputed(String key, String computedEl) {
        ExprParser exprParser = new ExprParser(computedEl);
        if (exprParser.isConstantExpr()) {
            this.variables.put(key, exprParser.evaluate());
        } else {
            if (exprParser.getInvokes().containsKey(key)) {
                throw new IllegalArgumentException("There is a variable with the same name key in the expression for '" + key + "'");
            }
            this.computedEls.put(key, exprParser);
            this.computable = true;
        }
        return this;
    }

    public EvaluateEnvironment clearFunctions() {
        this.functionMap.clear();
        this.staticMethods.clear();
        this.staticClassSet.clear();
        return this;
    }

    public EvaluateEnvironment clear() {
        this.clearFunctions();
        this.variables.clear();
        this.computedEls.clear();
        this.computable = false;
        return this;
    }

    final Object computedVariables() {
        return this.computedVariables(this.getContext());
    }

    final Object computedVariables(Object context) {
        if (!this.computable) {
            return context;
        }
        Map<String, Object> newContext = this.newContext(context);
        Collection<Map.Entry<String, ExprParser>> entrySet = this.computedEls.entrySet();
        int count = entrySet.size();
        while (count-- > 0) {
            ArrayList<Map.Entry> nextEntrys = new ArrayList<Map.Entry>();
            for (Map.Entry entry : entrySet) {
                String key = (String)entry.getKey();
                if (newContext.containsKey(key)) continue;
                ExprParser exprParser = (ExprParser)entry.getValue();
                if (this.checkVariableDependencies(newContext, exprParser.getInvokes())) {
                    Object result = exprParser.evaluateInternal(newContext, this);
                    newContext.put(key, result);
                    continue;
                }
                nextEntrys.add(entry);
            }
            if (nextEntrys.isEmpty()) break;
            entrySet = nextEntrys;
        }
        this.computable = true;
        return newContext;
    }

    private Map<String, Object> newContext(Object context) {
        HashMap<String, Object> newContext = new HashMap<String, Object>(this.variables);
        if (context instanceof Map) {
            newContext.putAll((Map)context);
        } else {
            BeanUtils.copy(context, newContext);
        }
        return newContext;
    }

    private boolean checkVariableDependencies(Map<String, Object> context, Map<String, ElVariableInvoker> invokes) {
        Set<Map.Entry<String, ElVariableInvoker>> entrySet = invokes.entrySet();
        for (Map.Entry<String, ElVariableInvoker> entry : entrySet) {
            ElVariableInvoker invoker = entry.getValue();
            if (invoker.parent != null || context.containsKey(entry.getKey())) continue;
            return false;
        }
        return true;
    }

    static {
        EvaluateEnvironment.registerStaticMethods(true, BuiltInFunction.class, BUILT_IN_STATIC_METHODS);
        DEFAULT = new EvaluateEnvironment();
    }

    private class MethodFunction
    implements ExprFunction<Object, Object> {
        private String name;
        private Method method;
        private Class[] parameterTypes;
        private int parameterLength;

        MethodFunction(String name, Method method) {
            this.name = name;
            this.method = method;
            this.parameterTypes = method.getParameterTypes();
            this.parameterLength = this.parameterTypes.length;
        }

        @Override
        public Object call(Object ... params) {
            try {
                if (this.parameterLength == 1 && this.parameterTypes[0].isArray()) {
                    Class<?> componentType = this.parameterTypes[0].getComponentType();
                    Object arrParam = Array.newInstance(componentType, params.length);
                    int i = 0;
                    for (Object param : params) {
                        Array.set(arrParam, i++, ObjectUtils.toType(param, componentType));
                    }
                    return this.method.invoke(null, arrParam);
                }
                for (int i = 0; i < this.parameterTypes.length; ++i) {
                    Object val = params[i];
                    Class parameterType = this.parameterTypes[i];
                    params[i] = ObjectUtils.toType(val, parameterType);
                }
                return this.method.invoke(null, params);
            }
            catch (Throwable e) {
                throw new ExpressionException(" method['@" + this.method + "'] invoke error: " + e.getMessage(), e);
            }
        }
    }
}

